<?php
$tab_posts = $args['tab_posts'] ?? [];
?>
<div class="_tabs">
    <div class="_tabs-nav">
		<?php foreach ( $tab_posts as $key => $post_item ) { ?>
			<?php
			$class_active = '';
			if ( $key == 0 ) {
				$class_active = ' _active';
			}

			$button_atts = [];
			$color       = get_post_meta( $post_item->ID, 'color_active', 1 );
			if ( $color ) {
				list( $r, $g, $b ) = sscanf( $color, "#%02x%02x%02x" );
				$button_atts[] = 'data-rgb="' . $r . ',' . $g . ',' . $b . '"';
			}

			$tooltip = get_post_meta( $post_item->ID, 'tooltip', 1 );
			if ( $tooltip ) {
				$button_atts[] = 'data-tippy-content="' . $tooltip . '"';
			}

			$icon_image = '';
			if ( $img_id = get_post_meta( $post_item->ID, 'icon', 1 ) ) {
				$icon_image = wp_get_attachment_image( $img_id, 'medium' );
			}
			?>
            <button class="_tabs-item<?php echo $class_active; ?>" type="button" <?php echo implode( ' ', $button_atts ); ?>>
				<?php if ( $icon_image ) { ?>
                    <div class="_tabs-item__top"><?php echo $icon_image; ?></div>
				<?php } ?>
                <span><?php echo $post_item->post_title; ?></span>
            </button>
		<?php } ?>
    </div>
    <div class="_tabs-body">
		<?php
		foreach ( $tab_posts as $key => $post_item ) {
			$class_active = $key == 0 ? ' _active' : '';

			$title      = get_post_meta( $post_item->ID, 'custom_title', 1 );
			$title_type = get_post_meta( $post_item->ID, 'title_type', 1 );
			if ( ! $title_type ) {
				$title_type = 'div';
			}
			$text = apply_filters( 'the_content', $post_item->post_content );

			$infotab_info = get_post_meta( $post_item->ID, 'infotab_info', 1 );

			$data_images    = [];
			$gallery_images = get_post_meta( $post_item->ID, 'gallery_images', 1 );
			if ( $gallery_images ) {
				foreach ( $gallery_images as $item ) {
					$html = '<div class="info-tabs-slide">';
					$html .= '<a href="' . $item['url'] . '">' . wp_get_attachment_image( $item['img_id'], 'medium_large' ) . '</a>';
					if ( $item['title'] ) {
						$html .= '<div class="info-tabs-slide__title">' . $item['title'] . '</div>';
					}
					$html .= '</div>';

					$data_images[] = $html;
				}
			}

			$is_slider     = get_post_meta( $post_item->ID, 'gallery_slider', 1 );
			$slider_arrows = get_post_meta( $post_item->ID, 'slider_arrows', 1 );
			$slider_dots   = get_post_meta( $post_item->ID, 'slider_dots', 1 ) ? 'true' : '';
			$slider_count  = floatval( get_post_meta( $post_item->ID, 'slider_count', 1 ) );
			if ( ! $slider_count ) {
				$slider_count = 5;
			}
			$slider_autoplay = get_post_meta( $post_item->ID, 'slider_autoplay', 1 );
			$autoplay_speed  = intval( get_post_meta( $post_item->ID, 'slider_autoplay_speed', 1 ) ) * 1000;
			$autoplay_speed  = $slider_autoplay ? $autoplay_speed : '';

			$button_text  = get_post_meta( $post_item->ID, 'button_text', 1 );
			$button_url   = get_post_meta( $post_item->ID, 'button_link', 1 );
			$target_blank = get_post_meta( $post_item->ID, 'button_link_is_blank', 1 ) ? 'target="_blank" rel="noopener noreferrer"' : '';
			?>
            <div class="_tabs-block<?php echo $class_active; ?>">
                <div class="info-tabs__grid">
					<?php
					if ( $title ) {
						printf( '<%1$s class="info-tabs__title">' . $title . '</%1$s>', $title_type );
					}
					?>
					<?php if ( $text ) { ?>
                        <div class="info-tabs__text"><?php echo $text; ?></div>
					<?php } ?>
					<?php if ( $data_images ) { ?>
						<?php if ( $is_slider ) { ?>
                            <div class="info-tabs__slider" data-pagination="<?php echo $slider_dots; ?>" data-autoplay="<?php echo $autoplay_speed; ?>" data-slides-1279="<?php echo $slider_count; ?>">
                                <div class="swiper-wrapper">
									<?php foreach ( $data_images as $item_html ) { ?>
                                        <div class="swiper-slide">
											<?php echo $item_html; ?>
                                        </div>
									<?php } ?>
                                </div>
								<?php if ( $slider_dots ) { ?>
                                    <div class="swiper-pagination"></div>
								<?php } ?>
								<?php if ( $slider_arrows ) { ?>
                                    <button class="_slider-navigation__prev" type="button" aria-label="prev">
                                        <svg width="11" height="19" viewbox="0 0 11 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M9.0419 1.02075L1 9.06265L9.0419 17.1046" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                        </svg>
                                    </button>
                                    <button class="_slider-navigation__next" type="button" aria-label="next">
                                        <svg width="11" height="19" viewbox="0 0 11 19" fill="none" xmlns="http://www.w3.org/2000/svg">
                                            <path d="M1.59189 17.1045L9.63379 9.06259L1.59189 1.02069" stroke="white" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"></path>
                                        </svg>
                                    </button>
								<?php } ?>
                            </div>
						<?php } else { ?>
							<?php
							$count = get_post_meta( $post_item->ID, 'count_in_row', 1 );
							if ( $count ) {
								$count = ' _' . $count;
							}
							?>
                            <div class="info-tabs__noslider<?php echo $count; ?>">
								<?php foreach ( $data_images as $item_html ) { ?>
									<?php echo $item_html; ?>
								<?php } ?>
                            </div>
						<?php } ?>
					<?php } ?>

					<?php
					if ( $infotab_info ) {
						echo '<div class="info-tabs__blocks">';
						foreach ( $infotab_info as $item ) {
							?>
                            <div class="info-tabs-block">
                                <div class="info-tabs-block__img"><?php echo wp_get_attachment_image( $item['img_id'] ); ?></div>
                                <div class="info-tabs-block__body">
									<?php if ( $item['title'] ) { ?>
                                        <div class="info-tabs-block__title"><?php echo $item['title']; ?></div>
									<?php } ?>
									<?php if ( $item['text'] ) { ?>
                                        <div class="info-tabs-block__text"><?php echo nl2br( $item['text'] ); ?></div>
									<?php } ?>
                                </div>
                            </div>
							<?php
						}
						echo '</div>';
					}
					?>

					<?php if ( $button_text && $button_url ) { ?>
                        <a class="btn btn-main btn-main_blue" href="<?php echo $button_url; ?>" <?php echo $target_blank; ?>><span><?php echo $button_text; ?></span></a>
					<?php } ?>
                </div>
            </div>
			<?php
		}
		?>
    </div>
</div>

