<?php
$block_enabled = get_theme_mod( 'home_information_enabled' );
if ( ! $block_enabled ) {
	return;
}

$title        = get_theme_mod( 'home_information_title' );
$title_type   = get_theme_mod( 'home_information_title_type', 'div' );
$text         = get_theme_mod( 'home_information_text' );
$link_label   = get_theme_mod( 'home_information_button_label' );
$link_url     = get_theme_mod( 'home_information_button_url' );
$slider_items = get_theme_mod( 'home_information_items', [] );

$title2      = get_theme_mod( 'home_information_title2' );
$text2       = get_theme_mod( 'home_information_text2' );
$link2_label = get_theme_mod( 'home_information_button2_label' );
$link2_url   = get_theme_mod( 'home_information_button2_url' );
$link2_blank = get_theme_mod( 'home_information_button2_target_blank' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_information_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_information_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$slider_speed         = get_theme_mod( 'home_information_settings_speed', 5 );
$slider_speed         = $slider_speed * 1000;
$slider_dots          = get_theme_mod( 'home_information_settings_dots', false ) == true ? 'true' : 'false';
$slider_arrows        = get_theme_mod( 'home_information_settings_arrow', true ) == true ? 'true' : 'false';
$slider_arrows_mobile = get_theme_mod( 'home_information_settings_arrow_mobile', true ) == true ? '' : '_hide-arrows-mobile';

$section_class    = '';
$section_position = get_theme_mod( 'home_information_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="information<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_information_image_bg' ); ?>
    <div class="container">
        <div class="slider-wrapper <?php echo $slider_arrows_mobile; ?>">
			<?php
			if ( $title ) {
				printf( '<%1$s class="information__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
            <div class="information__top _section-about">
				<?php if ( $text ) { ?>
                    <div class="_section-about__text"><?php echo $text; ?></div>
				<?php } ?>
				<?php if ( $link_label && $link_url ) { ?>
                    <a class="information__link" href="<?php echo $link_url; ?>"><?php echo $link_label; ?></a>
				<?php } ?>
                <div class="slider-buttons">
                    <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                    <button class="slider-buttons__item slider-buttons__item_next" type="button">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                            <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                        </svg>
                    </button>
                </div>
            </div>
            <div class="information__slider" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
				<?php foreach ( $slider_items as $item ) { ?>
					<?php
					$custom_class = '';
					$object_fit   = $item['image_object_fit'] ?? 'cover';
					if ( $item['image'] && $object_fit && $object_fit !== 'cover' ) {
						$custom_class = ' _img-contain';
					}
					?>
                    <div class="information__slide">
                        <div class="information-item<?php echo $custom_class; ?>">
							<?php if ( $item['image'] ) { ?>
                                <div class="information-item__img">
									<?php echo wp_get_attachment_image( $item['image'] ); ?>
                                </div>
							<?php } ?>
                            <div class="information-item__title"><?php echo $item['title']; ?></div>
                            <div class="information-item__text">
                                <p><?php echo nl2br( $item['text'] ); ?></p>
                            </div>
                        </div>
                    </div>
				<?php } ?>
            </div>
        </div>
		<?php if ( $title2 || $text2 ) { ?>
            <div class="information-about">
				<?php if ( $title2 ) { ?>
                    <div class="information-about__title"><?php echo $title2; ?></div>
				<?php } ?>
                <div class="information-about__body">
					<?php if ( $text2 ) { ?>
                        <div class="information-about__text"><?php echo $text2; ?></div>
					<?php } ?>
					<?php if ( $link2_label && $link2_url ) { ?>
						<?php
						$target       = $link2_blank ? 'target="_blank"' : '';
						$custom_class = '';

						if ( strpos( $link2_url, '#wescle-modal' ) !== false || $link2_url == '#modal-call' ) {
							$custom_class = ' _popup-link';
						}
						?>
                        <a class="information__btn btn btn-main<?php echo $custom_class; ?>" href="<?php echo $link2_url; ?>"><span><?php echo $link2_label; ?></span></a>
					<?php } ?>
                </div>
            </div>
		<?php } ?>
    </div>
</div>      