<?php
$block_enabled = get_theme_mod( 'info_plus_banner_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'info_plus_banner_title' );
$title_type = get_theme_mod( 'info_plus_banner_title_type', 'div' );
$text       = get_theme_mod( 'info_plus_banner_text' );
$img_id     = get_theme_mod( 'info_plus_banner_image' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'info_plus_banner_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'info_plus_banner_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'info_plus_banner_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="about-us<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'info_plus_banner_image_bg' ); ?>
    <div class="container">
		<?php if ( $img_id ) { ?>
            <div class="about-us__img">
				<?php echo wp_get_attachment_image( $img_id, 'full' ); ?>
            </div>
		<?php } ?>
        <div class="about-us__body">
			<?php
			if ( $title ) {
				printf( '<%1$s class="about-us__title title" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="about-us__text"><?php echo $text; ?></div>
			<?php } ?>
        </div>
    </div>
</div>
