<?php
$block_enabled = get_theme_mod( 'home_how_work2_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$items = get_theme_mod( 'home_how_work2_items', [] );
if ( ! $items ) {
	return;
}

$title      = get_theme_mod( 'home_how_work2_title' );
$title_type = get_theme_mod( 'home_how_work2_title_type', 'div' );
$text       = get_theme_mod( 'home_how_work2_text' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_how_work2_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_how_work2_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_how_work2_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="how-we-working-v2<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_how_work2_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="how-we-working-v2__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="_section-about__text"><?php echo $text; ?></div>
            </div>
		<?php } ?>
        <div class="how-we-working-v2__grid">
			<?php foreach ( $items as $item ) { ?>
                <div class="how-we-working-v2-item">
                    <div class="how-we-working-v2-item__img">
						<?php echo wp_get_attachment_image( $item['image_id'], 'medium' ); ?>
                    </div>
                    <div class="how-we-working-v2-item__title"><?php echo $item['title']; ?></div>
					<?php if ( $item['text'] ) { ?>
                        <div class="how-we-working-v2-item__text"><?php echo nl2br( $item['text'] ); ?></div>
					<?php } ?>
					<?php if ( isset( $item['button_label'] ) && $item['button_label'] && $item['button_url'] ) { ?>
						<?php
						$target = '';
						if ( $item['button_blank'] ) {
							$target = ' target="_blank"';
						}
						$class = 'btn btn-main';
						if ( strpos( $item['button_url'], '#wescle-modal' ) !== false || $item['button_url'] == '#modal-call' ) {
							$class .= ' _popup-link';
						}
						?>
                        <a class="<?php echo $class; ?>" href="<?php echo $item['button_url']; ?>"<?php echo $target; ?>><?php echo $item['button_label']; ?></a>
					<?php } ?>
                </div>
			<?php } ?>
        </div>
    </div>
</div>