<?php
$block_enabled = get_theme_mod( 'home_how_work_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$items = get_theme_mod( 'home_how_work_items', [] );
if ( ! $items ) {
	return;
}

$suptitle   = get_theme_mod( 'home_how_work_suptitle' );
$title      = get_theme_mod( 'home_how_work_title' );
$title_type = get_theme_mod( 'home_how_work_title_type', 'div' );
$text       = get_theme_mod( 'home_how_work_text' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_how_work_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_how_work_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_how_work_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="how-we-working<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_how_work_image_bg' ); ?>
    <div class="container">
		<?php if ( $suptitle ) { ?>
            <div class="how-we-working__subtitle"><?php echo $suptitle; ?></div>
		<?php } ?>
		<?php
		if ( $title ) {
			printf( '<%1$s class="how-we-working__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		} ?>
		<?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="_section-about__text"><?php echo $text; ?></div>
            </div>
		<?php } ?>
        <div class="how-we-working__grid how-we-working__count-<?php echo count( $items ); ?>">
			<?php
			foreach ( $items as $item ) {
				$style = '';
				if ( $item['bg_color'] ) {
					$style = 'style="background-color:' . $item['bg_color'] . '"';
				}
				?>
                <div class="how-we-working-item">
                    <div class="how-we-working-item__img" <?php echo $style; ?>>
						<?php echo wp_get_attachment_image( $item['image_id'], 'medium' ); ?>
                    </div>
                    <div class="how-we-working-item__title"><?php echo nl2br( $item['title'] ); ?></div>
                    <div class="how-we-working-item__text"><?php echo nl2br( $item['text'] ); ?></div>
                </div>
			<?php } ?>
        </div>
    </div>
</div>