<?php
$block_enabled = get_theme_mod( 'home_gallery_enabled', false );
if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'home_gallery_enabled_home', true ) ) {
		return;
	}
}

$title      = get_theme_mod( 'home_gallery_title' );
$title_type = get_theme_mod( 'home_gallery_title_type', 'div' );
$text       = get_theme_mod( 'home_gallery_text' );
$term_items = get_theme_mod( 'home_gallery_items', [] );

$term_ids = [];
if ( $term_items ) {
	foreach ( $term_items as $term_item ) {
		$term_ids[] = intval( $term_item['faq_cat'] );
	}
}

$terms = get_terms( [
	'taxonomy' => 'gallerycat_wescle',
	'include'  => $term_ids,
	'orderby'  => 'include',
] );
$terms = array_values( $terms );

$args = [
	'post_type'        => 'gallery_wescle',
	'posts_per_page'   => - 1,
	'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
	'suppress_filters' => false
];
if ( $term_ids ) {
	$args['tax_query'] = [
		[
			'taxonomy' => 'gallerycat_wescle',
			'terms'    => $term_ids
		]
	];
}
$posts_gallery = get_posts( $args );
if ( ! $posts_gallery ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_gallery_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_gallery_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

if ( is_page_template( 'templates/template-gallery.php' ) ) {
	$style_bg    = '';
	$style_title = '';
	$title       = '';
	$text        = '';
}

$btn_flare = '';
if ( get_theme_mod( 'gallery_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}

$hide_button_all      = get_theme_mod( 'home_gallery_hide_filter_all', false );
$slider_enabled       = get_theme_mod( 'home_gallery_slider_enabled' );
$slides_count         = get_theme_mod( 'home_gallery_count_slides', 3 );
$slider_speed         = get_theme_mod( 'home_gallery_slider_speed', 5 );
$slider_speed         = $slider_speed * 1000;
$slider_dots          = get_theme_mod( 'home_gallery_slider_dots', false ) ? 'true' : 'false';
$slider_arrows        = get_theme_mod( 'home_gallery_slider_arrow', true ) ? 'true' : 'false';
$slider_arrows_mobile = get_theme_mod( 'home_gallery_slider_arrow_mobile', true ) ? '' : '_hide-arrows-mobile';
if ( $slider_enabled ) {
	$hide_button_all = true;
}

$section_class    = '';
$section_position = get_theme_mod( 'home_gallery_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}

if ( $slider_enabled ) {
	$section_class .= ' _with-slider';
}
?>
<div class="our-works<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_gallery_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $slider_enabled ) {
			include get_template_directory() . '/template-parts/home/gallery-slider.php';
		}
		else {
			include get_template_directory() . '/template-parts/home/gallery-grid.php';
		}
		?>
    </div>
</div>