<div class="slider-wrapper _hide-arrows-mobile">
	<?php if ( $title || $text ) { ?>
        <div class="our-works__top">
			<?php
			if ( $title ) {
				printf( '<%1$s class="our-works__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="our-works__text _section-about"><?php echo $text; ?></div>
			<?php } ?>
        </div>
	<?php } ?>
    <div class="our-works__gallery">
        <div class="our-works__filters">
			<?php if ( ! $hide_button_all ) { ?>
                <div class="our-works__filters-item">
                    <button class="active btn btn-main <?php echo $btn_flare; ?>" type="button" data-filter="all"><?php _ex( 'Все', 'filter', 'wescle' ); ?></button>
                </div>
			<?php } ?>
			<?php
			if ( count( $terms ) > 1 ) {
				foreach ( $terms as $key => $term ) { ?>
					<?php
					$class_button = 'btn btn-main';
					if ( $hide_button_all && $key == 0 ) {
						$class_button = 'active btn btn-main';
					}
					?>
                    <div class="our-works__filters-item">
                        <button class="<?php echo $class_button; ?> <?php echo $btn_flare; ?>" type="button" data-filter="our-works-<?php echo $term->term_id; ?>"><?php echo $term->name; ?></button>
                    </div>
					<?php
				}
			}
			?>
        </div>
    </div>

	<?php
	$other_images = [];
	?>
    <div class="our-works__sliders">
		<?php foreach ( $terms as $key => $term ) { ?>
			<?php
			$args          = [
				'post_type'        => 'gallery_wescle',
				'posts_per_page'   => - 1,
				'orderby'          => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
				'suppress_filters' => false,
				'tax_query'        => [
					[
						'taxonomy' => 'gallerycat_wescle',
						'terms'    => $term->term_id
					]
				]
			];
			$posts_gallery = get_posts( $args );

			$class_wrap = $key == 0 ? 'our-works__slider-wrap active' : 'our-works__slider-wrap';
			?>
            <div class="<?php echo $class_wrap; ?>" data-slider="our-works-<?php echo $term->term_id; ?>">
				<?php if ( $slider_arrows === 'true' ) { ?>
                    <div class="slider-buttons">
                        <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                            </svg>
                        </button>
                        <button class="slider-buttons__item slider-buttons__item_next" type="button">
                            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                                <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                            </svg>
                        </button>
                    </div>
				<?php } ?>

                <div class="our-works__slider" data-slides="<?php echo $slides_count; ?>" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
					<?php
					foreach ( $posts_gallery as $post ) {
						setup_postdata( $post );

						$img_id = get_post_meta( $post->ID, '_thumbnail_id', 1 );
						if ( ! $img_id ) {
							continue;
						}

						$gallery_images = get_post_meta( $post->ID, 'gallery_images', true );
						if ( $gallery_images ) {
							$other_images[ $post->ID ] = wp_list_pluck( $gallery_images, 'img_id' );
						}

						$post_term_ids = [];
						$post_terms    = get_the_terms( $post, 'gallerycat_wescle' );
						if ( $post_terms ) {
							foreach ( $post_terms as $post_term ) {
								$post_term_ids[] = $post_term->term_id;
							}
						}

						if ( $hide_button_all ) {
							$link_class = 'our-works-block';
							if ( $terms && in_array( $terms[0]->term_id, $post_term_ids ) ) {
								$link_class .= ' active';
							}
						}
						else {
							$link_class = 'our-works-block active';
						}

						$id_gallery = $gallery_images ? 'gallery-' . $post->ID : 'gallery';
						?>
                        <a class="<?php echo $link_class; ?>" data-gallery="<?php echo $id_gallery; ?>" data-fslightbox="<?php echo $id_gallery; ?>" data-filter-item="our-works-<?php echo implode( ',our-works-', $post_term_ids ); ?>" href="<?php echo wp_get_attachment_url( $img_id ); ?>">
                            <div class="our-works-block__img"><?php echo wp_get_attachment_image( $img_id, 'medium_large' ); ?></div>
                            <div class="our-works-block__body">
                                <div class="our-works-block__title"><?php echo $post->post_title; ?></div>
								<?php if ( $post->post_content ) { ?>
                                    <div class="our-works-block__text"><?php echo $post->post_content; ?></div>
								<?php } ?>
                            </div>
                        </a>
						<?php
					}
					wp_reset_postdata();
					?>
                </div>
            </div>
		<?php } ?>
    </div>

	<?php
	if ( $other_images ) {
		echo '<div class="_hidden-images">';
		foreach ( $other_images as $post_id => $img_ids ) {
			$id_gallery = 'gallery-' . $post_id;
			foreach ( $img_ids as $img_id ) {
				?>
                <a data-gallery="<?php echo $id_gallery; ?>" data-fslightbox="<?php echo $id_gallery; ?>" href="<?php echo wp_get_attachment_url( $img_id ); ?>"></a>
				<?php
			}
		}
		echo '</div>';
	}
	?>
</div>

