<?php
if ( $title ) {
	printf( '<%1$s class="our-works__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
}
?>
<?php if ( $text ) { ?>
	<?php if ( isset( $block_attributes['aboutImg'] ) ) { ?>
		<?php echo wp_get_attachment_image( $block_attributes['aboutImg']['id'], 'medium_large' ); ?>
	<?php } ?>
    <div class="our-works__text"><?php echo $text; ?></div>
<?php } ?>

<div class="our-works__gallery">
    <div class="our-works__filters">
		<?php if ( ! $hide_button_all ) { ?>
            <div class="our-works__filters-item">
                <button class="active btn btn-main <?php echo $btn_flare; ?>" type="button" data-filter="all"><?php _ex( 'Все', 'filter', 'wescle' ); ?></button>
            </div>
		<?php } ?>
		<?php
		if ( count( $terms ) > 1 ) {
			foreach ( $terms as $key => $term ) { ?>
				<?php
				$class_button = 'btn btn-main';
				if ( $hide_button_all && $key == 0 ) {
					$class_button = 'active btn btn-main';
				}
				?>
                <div class="our-works__filters-item">
                    <button class="<?php echo $class_button; ?> <?php echo $btn_flare; ?>" type="button" data-filter="our-works-<?php echo $term->term_id; ?>"><?php echo $term->name; ?></button>
                </div>
				<?php
			}
		}
		?>
    </div>

    <div class="our-works__grid">
		<?php
		$other_images = [];
		foreach ( $posts_gallery as $post ) {
			setup_postdata( $post );

			$img_id = get_post_meta( $post->ID, '_thumbnail_id', 1 );
			if ( ! $img_id ) {
				continue;
			}

			$gallery_images = get_post_meta( $post->ID, 'gallery_images', true );
			if ( $gallery_images ) {
				$other_images[ $post->ID ] = wp_list_pluck( $gallery_images, 'img_id' );
			}

			$post_term_ids = [];
			$post_terms    = get_the_terms( $post, 'gallerycat_wescle' );
			if ( $post_terms ) {
				foreach ( $post_terms as $post_term ) {
					$post_term_ids[] = $post_term->term_id;
				}
			}

			if ( $hide_button_all ) {
				$link_class = 'our-works-block';
				if ( $terms && in_array( $terms[0]->term_id, $post_term_ids ) ) {
					$link_class .= ' active';
				}
			}
			else {
				$link_class = 'our-works-block active';
			}

			$id_gallery = $gallery_images ? 'gallery-' . $post->ID : 'gallery';
			?>
            <a class="<?php echo $link_class; ?>" data-gallery="<?php echo $id_gallery; ?>" data-fslightbox="<?php echo $id_gallery; ?>" data-filter-item="our-works-<?php echo implode( ',our-works-', $post_term_ids ); ?>" href="<?php echo wp_get_attachment_url( $img_id ); ?>">
                <div class="our-works-block__img"><?php echo wp_get_attachment_image( $img_id, 'medium_large' ); ?></div>
                <div class="our-works-block__body">
                    <div class="our-works-block__title"><?php echo $post->post_title; ?></div>
					<?php if ( $post->post_content ) { ?>
                        <div class="our-works-block__text"><?php echo $post->post_content; ?></div>
					<?php } ?>
                </div>
            </a>
			<?php
		}
		wp_reset_postdata();
		?>
    </div>
	<?php
	if ( $other_images ) {
		echo '<div class="_hidden-images">';
		foreach ( $other_images as $post_id => $img_ids ) {
			$id_gallery = 'gallery-' . $post_id;
			foreach ( $img_ids as $img_id ) {
				?>
                <a data-gallery="<?php echo $id_gallery; ?>" data-fslightbox="<?php echo $id_gallery; ?>" href="<?php echo wp_get_attachment_url( $img_id ); ?>"></a>
				<?php
			}
		}
		echo '</div>';
	}
	?>
</div>
