<?php
$block_enabled = get_theme_mod( 'home_faq_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_faq_title' );
$title_type = get_theme_mod( 'home_faq_title_type', 'div' );
$text       = get_theme_mod( 'home_faq_text' );
$faq_items  = get_theme_mod( 'home_faq_items', [] );
if ( ! $faq_items ) {
	return;
}

$column_two   = get_theme_mod( 'home_faq_columns_two' ) ? ' _col-2' : '';
$column_width = get_theme_mod( 'home_faq_columns_width', 575 );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_faq_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_faq_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class = '';
if ( get_theme_mod( 'home_faq_after_title' ) ) {
	$section_class .= ' _column';
}
$section_position = get_theme_mod( 'home_faq_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="faq<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_faq_image_bg' ); ?>
    <div class="container">
        <div class="faq__row">
			<?php if ( $title || $text ) { ?>
                <div class="faq__col">
					<?php
					if ( $title ) {
						printf( '<%1$s class="faq__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
					}
					?>
                    <div class="faq__text">
						<?php echo $text; ?>
                    </div>
                </div>
			<?php } ?>
            <div class="faq__col accardeon<?php echo $column_two; ?>" data-max-width="<?php echo $column_width; ?>">
		        <?php foreach ( $faq_items as $item ) { ?>
                    <div class="faq-item">
                        <button class="accardeon__title faq-item__title"><span><?php echo $item['title']; ?></span>
                            <svg class="feather feather-plus" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewbox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                <line x1="12" y1="5" x2="12" y2="19"></line>
                                <line x1="5" y1="12" x2="19" y2="12"></line>
                            </svg>
                        </button>
                        <div class="faq-item__body">
					        <?php echo wpautop( $item['text'] ); ?>
                        </div>
                    </div>
				<?php } ?>
            </div>
        </div>
    </div>
</div>