<?php
$block_enabled = get_theme_mod( 'home_events_enabled', false );
if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'home_events_enabled_home', true ) ) {
		return;
	}
}

$title      = get_theme_mod( 'home_events_title' );
$title_type = get_theme_mod( 'home_events_title_type', 'div' );
$text       = get_theme_mod( 'home_events_text' );
$link       = '';
$link_id    = get_theme_mod( 'home_events_link_id', 0 );
if ( $link_id ) {
	$link = get_permalink( $link_id );
}
$link_text            = get_theme_mod( 'home_events_link_text', Helper::get_default_theme_data( 'home_events_link_text' ) );
$home_portfolio_posts = get_theme_mod( 'home_events_posts', [] );
$more_text            = get_theme_mod( 'home_events_more_text', Helper::get_default_theme_data( 'home_events_more_text' ) );

$event_post_ids = [];
foreach ( $home_portfolio_posts as $item ) {
	if ( $item['post_id'] ) {
		$event_post_ids[] = $item['post_id'];
	}
}

$posts_per_page = get_theme_mod( 'content_box', 'box' ) == 'box' ? 4 : 5;
$post__in       = [];
$orderby        = [ 'meta_value_num' => 'ASC', 'menu_order' => 'ASC' ];
if ( $event_post_ids ) {
	$posts_per_page = count( $event_post_ids );
	$post__in       = $event_post_ids;
}

$args        = [
	'post_type'        => 'event_wescle',
	'posts_per_page'   => $posts_per_page,
	'post__in'         => $post__in,
	'orderby'          => $orderby,
	'meta_query'       => [
		[
			'key'     => 'event_date',
			'value'   => current_time( 'Ymd' ),
			'compare' => '>=',
			'type'    => 'NUMERIC'
		]
	],
	'suppress_filters' => false
];
$event_posts = get_posts( $args );
if ( ! $event_posts ) {
	return;
}

$args_next                   = $args;
$args_next['posts_per_page'] = $posts_per_page + 1;
$args_next['fields']         = 'ids';

$event_posts_next = get_posts( $args_next );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_events_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_events_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_events_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="events-block<?php echo $section_class; ?>" id="events-block" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_events_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="events-block__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
        <div class="events-block__about">
			<?php if ( $text ) { ?>
                <div class="events-block__text"><?php echo $text; ?></div>
			<?php } ?>
			<?php if ( $link && $link_text ) { ?>
                <a class="events-block__link" href="<?php echo $link; ?>"><?php echo esc_html( $link_text ); ?></a>
			<?php } ?>
        </div>
        <div class="events-block__grid">
			<?php
			$event_post_ids = [];
			foreach ( $event_posts as $post ) {
				setup_postdata( $post );
				$event_post_ids[] = $post->ID;

				get_template_part( 'template-parts/content/event', 'item' );
			}
			wp_reset_postdata();
			?>
        </div>
		<?php if ( $more_text && count( $event_posts_next ) > $posts_per_page ) { ?>
            <div class="events-block__more">
                <a class="btn btn-main btn-more-events" data-paged="1" data-per_page="<?php echo $posts_per_page; ?>" data-event_post_ids="<?php echo implode( ',', $event_post_ids ); ?>" href="#"><?php echo $more_text; ?></a>
            </div>
		<?php } ?>
    </div>
</div>