<?php
$block_enabled = get_theme_mod( 'home_difference_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title             = get_theme_mod( 'home_difference_title' );
$title_type        = get_theme_mod( 'home_difference_title_type', 'div' );
$text              = get_theme_mod( 'home_difference_text' );
$image_before      = get_theme_mod( 'home_difference_before' );
$image_after       = get_theme_mod( 'home_difference_after' );
$scroller_position = get_theme_mod( 'home_difference_position', 50 );

if ( ! $image_before || ! $image_after ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_difference_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_difference_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_difference_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="difference<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_difference_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="difference__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="difference__text">
				<?php echo $text; ?>
            </div>
		<?php } ?>
        <div class="difference__body">
            <div class="difference__layout">
                <div class="difference__before">
                    <div class="difference__image">
						<?php echo wp_get_attachment_image( $image_before, 'full' ); ?>
                    </div>
                </div>
                <div class="difference__after">
                    <div class="difference__image">
						<?php echo wp_get_attachment_image( $image_after, 'full' ); ?>
                    </div>
                </div>
                <div class="difference-scroller" data-position-percent="<?php echo $scroller_position; ?>">
                    <svg class="difference-scroller__thumb" xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewbox="0 0 100 100">
                        <polygon points="0 50 37 68 37 32 0 50" style="fill:#fff"></polygon>
                        <polygon points="100 50 64 32 64 68 100 50" style="fill:#fff"></polygon>
                    </svg>
                </div>
            </div>
        </div>
    </div>
</div>
