<?php
$block_enabled = get_theme_mod( 'home_contact_enabled', false );
if ( ! $block_enabled ) {
	return;
}

if ( is_front_page() ) {
    if ( ! get_theme_mod('home_contact_enabled_home', true) ) {
        return;
    }
}

$title      = get_theme_mod( 'home_contact_title' );
$title_type = get_theme_mod( 'home_contact_title_type', 'div' );

$block_left_title  = get_theme_mod( 'home_contact_block_left_title' );
$block_left_text   = get_theme_mod( 'home_contact_block_left_text' );
$block_left_text2  = get_theme_mod( 'home_contact_block_left_text2' );
$block_left_map    = get_theme_mod( 'home_contact_block_left_map' );
$block_left_phones = get_theme_mod( 'home_contact_block_left_phones', [] );

$block_right_title = get_theme_mod( 'home_contact_block_right_title' );
$block_right_text  = get_theme_mod( 'home_contact_block_right_text' );
$home_contact_cf7  = get_theme_mod( 'home_contact_cf7' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_contact_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_contact_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

if ( is_page_template( 'templates/template-contact.php' ) ) {
	$style_bg    = '';
	$style_title = '';
	$title       = '';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_contact_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="contact-us<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_contact_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="contact-us__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
        <div class="contact-us__grid">
            <div class="contact-us-info">
				<?php if ( $block_left_title ) { ?>
                    <h3 class="contact-us__subtitle"><?php echo $block_left_title; ?></h3>
				<?php } ?>
				<?php if ( $block_left_text ) { ?>
                    <div class="contact-us__text"><?php echo $block_left_text; ?></div>
				<?php } ?>
				<?php if ( $block_left_phones ) { ?>
                    <div class="contact-us__tel">
						<?php
						foreach ( $block_left_phones as $item ) {
							if ( ! $item['number'] ) {
								continue;
							}
							$anchor = $item['anchor'] ? $item['anchor'] : $item['number'];
							?>
                            <a href="tel:<?php echo Helper::phone_number_format( $item['number'] ); ?>"> <?php echo Helper::phone_number_mask( $anchor ); ?></a>
						<?php } ?>
                    </div>
				<?php } ?>
	            <?php if ( $block_left_text2 ) { ?>
                    <div class="contact-us-schedule"><?php echo $block_left_text2; ?></div>
	            <?php } ?>
	            <?php if ( $block_left_map ) { ?>
                    <div class="contact-us__map"><?php echo $block_left_map; ?></div>
	            <?php } ?>
            </div>
            <div class="contact-us-form">
		        <?php if ( $block_right_title ) { ?>
                    <div class="contact-us__subtitle"><?php echo $block_right_title; ?></div>
		        <?php } ?>
		        <?php if ( $block_right_text ) { ?>
                    <div class="contact-us__text"><?php echo $block_right_text; ?></div>
		        <?php } ?>
		        <?php
		        if ( $home_contact_cf7 ) {
			        echo do_shortcode( '[contact-form-7 id="' . $home_contact_cf7 . '"]' );
		        }
		        ?>
            </div>
        </div>
    </div>
</div>