<?php
$block_enabled = get_theme_mod( 'home_checklist_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title       = get_theme_mod( 'home_checklist_title' );
$title_type  = get_theme_mod( 'home_checklist_title_type', 'div' );
$text        = get_theme_mod( 'home_checklist_text' );
$plus_items  = get_theme_mod( 'home_checklist_plus', [] );
$minus_items = get_theme_mod( 'home_checklist_minus', [] );

$block_title_plus  = get_theme_mod( 'home_checklist_title_plus' );
$block_title_minus = get_theme_mod( 'home_checklist_title_minus' );

$text_open  = get_theme_mod( 'home_checklist_open', Helper::get_text_label( 'open_all' ) );
$text_close = get_theme_mod( 'home_checklist_close', Helper::get_text_label( 'close_all' ) );

$style_checklist_plus_label = '';
$style_inner_bg_plus        = [];
if ( $color = get_theme_mod( 'home_checklist_bg_plus' ) ) {
	$style_inner_bg_plus[] = 'background-color:' . $color . ';';
}
if ( $color_border_plus = get_theme_mod( 'home_checklist_border_plus' ) ) {
	$style_inner_bg_plus[]      = 'border:2px solid ' . $color_border_plus . ';';
	$style_checklist_plus_label = 'style="background-color:' . $color_border_plus . '"';
}
if ( $style_inner_bg_plus ) {
	$style_inner_bg_plus = 'style="' . implode( '', $style_inner_bg_plus ) . '"';
}
else {
	$style_inner_bg_plus = '';
}

$style_checklist_minus_label = '';
$style_inner_bg_minus        = [];
if ( $color = get_theme_mod( 'home_checklist_bg_minus' ) ) {
	$style_inner_bg_minus[] = 'background-color:' . $color . ';';
}
if ( $color_border_minus = get_theme_mod( 'home_checklist_border_minus', '#ef383f' ) ) {
	$style_inner_bg_minus[]      = 'border:2px solid ' . $color_border_minus . ';';
	$style_checklist_minus_label = 'style="background-color:' . $color_border_minus . '"';
}
if ( $style_inner_bg_minus ) {
	$style_inner_bg_minus = 'style="' . implode( '', $style_inner_bg_minus ) . '"';
}
else {
	$style_inner_bg_minus = '';
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_checklist_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_checklist_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_checklist_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="checklist<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_checklist_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="checklist__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="_section-about__text">
					<?php echo $text; ?>
                </div>
            </div>
		<?php } ?>
        <div class="checklist__grid">
            <div class="checklist__col checklist__col_main">
				<?php if ( $block_title_plus ) { ?>
                    <span class="checklist__label _animated" <?php echo $style_checklist_plus_label; ?>><?php echo $block_title_plus; ?></span>
				<?php } ?>
                <ul class="checklist__list" <?php echo $style_inner_bg_plus; ?>>
					<?php foreach ( $plus_items as $item ) { ?>
						<?php if ( $item['text'] ) { ?>
                            <li><?php echo nl2br( $item['text'] ); ?></li>
						<?php } ?>
					<?php } ?>
                </ul>
                <button class="checklist__more _hide" type="button" aria-expanded="false" title="<?php echo $text_open; ?>" data-view="<?php echo $text_open; ?>" data-close="<?php echo $text_close; ?>"></button>
            </div>
            <div class="checklist__col checklist__col_bonus">
				<?php if ( $block_title_minus ) { ?>
                    <span class="checklist__label _animated" <?php echo $style_checklist_minus_label; ?>><?php echo $block_title_minus; ?></span>
				<?php } ?>
                <ul class="checklist__list" <?php echo $style_inner_bg_minus; ?>>
					<?php foreach ( $minus_items as $item ) { ?>
						<?php if ( $item['text'] ) { ?>
                            <li><?php echo nl2br( $item['text'] ); ?></li>
						<?php } ?>
					<?php } ?>
                </ul>
                <button class="checklist__more _hide" type="button" aria-expanded="false" title="<?php echo $text_open; ?>" data-view="<?php echo $text_open; ?>" data-close="<?php echo $text_close; ?>"></button>
            </div>
        </div>
    </div>
</div>


