<?php
$block_enabled = get_theme_mod( 'home_characteristics_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$items = get_theme_mod( 'home_characteristics_items', [] );
if ( ! $items ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_characteristics_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_characteristics_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$btn_flare = '';
if ( get_theme_mod( 'characteristics_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_characteristics_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="characteristics<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_characteristics_image_bg' ); ?>
    <div class="container">
		<?php
		foreach ( $items as $item ) {
			$title               = $item['title'];
			$title_type          = isset( $item['title_type'] ) && $item['title_type'] ? $item['title_type'] : 'div';
			$block_align         = $item['block_align'] == 'left' ? 'reverse' : '';
			$text_about          = $item['text_about'] ?? '';
			$text                = trim( $item['text'] );
			$list_type           = $item['list_type'];
			$image_id            = $item['image_id'];
			$file_url            = $item['file_url'];
			$youtube_url         = $item['youtube_url'];
			$button_label        = $item['button_label'];
			$button_link         = $item['button_link'];
			$button_target_blank = $item['button_target_blank'] ? 'target="_blank" rel="noopener noreferrer"' : '';

			$video_id = Helper::get_youtube_video_id( $youtube_url );
			if ( $video_id || $file_url ) {
				if ( $image_id ) {
					$video_bg = wp_get_attachment_image_src( $image_id, 'medium_large' );
					if ( $video_bg ) {
						$video_img_src = $video_bg[0];
					}
				}
				else {
					$video_img_src = get_template_directory_uri() . '/assets/img/thumbnail-placeholder.jpg';
				}
			}
			?>
            <div class="row characteristics__row <?php echo $block_align; ?>">
                <div class="col characteristics__col">
					<?php
					if ( $video_id ) {
						?>
                        <div class="video-iframe lazy-background" data-background-image="<?php echo $video_img_src; ?>" data-src="https://www.youtube.com/embed/<?php echo $video_id; ?>?autoplay=1&rel=0&showinfo=0">
                            <div class="btn-play">
                                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 448 512">
                                    <path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z" fill="white"></path>
                                </svg>
                            </div>
                        </div>
						<?php
					}
                    elseif ( $file_url ) {
	                    ?>
                        <div class="characteristics__image">
                            <video controls preload="none" poster="<?php echo $video_img_src; ?>">
                                <source src="<?php echo wp_get_attachment_url( $file_url ); ?>" type="video/mp4">
                            </video>
                        </div>
	                    <?php
                    }
                    elseif ( $image_id ) {
						echo '<div class="characteristics__image">';
						echo wp_get_attachment_image( $image_id, 'medium_large' );
						echo '</div>';
					}
					?>
                </div>
                <div class="col characteristics__col">
		            <?php
		            if ( $title ) {
			            printf( '<%1$s class="characteristics__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		            }
		            ?>
		            <?php if ( $text_about ) { ?>
                        <div class="_section-about">
                            <div class="_section-about__text">
					            <?php echo wpautop( $text_about ); ?>
                            </div>
                        </div>
		            <?php } ?>
		            <?php
		            if ( $text ) {
			            $text_arr = explode( "\n", str_replace( "\r", "", $text ) );
			            ?>
                        <div class="characteristics__list">
				            <?php foreach ( $text_arr as $text_line ) { ?>
                                <div class="characteristics__list-item">
                                    <div class="characteristics__list-img">
                                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 16 16">
                                            <g fill="#08c">
                                                <path fill-rule="evenodd" d="M10.97 4.97a.75.75 0 0 1 1.071 1.05l-3.992 4.99a.75.75 0 0 1-1.08.02L4.324 8.384a.75.75 0 1 1 1.06-1.06l2.094 2.093l3.473-4.425a.236.236 0 0 1 .02-.022z"></path>
                                            </g>
                                        </svg>
                                    </div>
                                    <span><?php echo $text_line; ?></span>
                                </div>
				            <?php } ?>
                        </div>
			            <?php
		            }
		            ?>
		            <?php if ( $button_link ) {
			            $class_popup = '';
			            if ( strpos( $button_link, '#wescle-modal' ) !== false || strpos( $button_link, '#modal' ) !== false ) {
				            $class_popup = '_popup-link';
			            }
			            ?>
                        <a class="characteristics__btn btn btn-main <?php echo $btn_flare; ?><?php echo $class_popup; ?>" href="<?php echo $button_link; ?>" <?php echo $button_target_blank; ?>><?php echo $button_label; ?></a>
		            <?php } ?>
                </div>
            </div>
		<?php } ?>
    </div>
</div>