<?php
if ( ! get_theme_mod( 'home_catalogcats_enabled' ) ) {
	return;
}

$title      = get_theme_mod( 'home_catalogcats_title', Helper::get_default_theme_data( 'home_catalogcats_title' ) );
$title_type = get_theme_mod( 'home_catalogcats_title_type', 'div' );
$text       = get_theme_mod( 'home_catalogcats_text' );

$link_url  = get_theme_mod( 'home_catalogcats_link_url' );
$link_text = get_theme_mod( 'home_catalogcats_link_text' );

$taxonomy = get_theme_mod( 'home_catalogcats_taxonomy' );
if ( ! $taxonomy ) {
	return;
}

$terms_args        = [
	'taxonomy'   => $taxonomy,
	'hide_empty' => false,
	'orderby'    => 'menu_order',
];
$category_selected = get_theme_mod( 'home_catalogcats_ids' );
if ( $category_selected ) {
	$category_selected     = array_map( 'trim', explode( ',', $category_selected ) );
	$terms_args['include'] = $category_selected;
	$terms_args['orderby'] = 'include';
}
else {
	$limit = intval( get_theme_mod( 'home_catalogcats_limit', 10 ) );
	if ( $limit < 1 ) {
		$limit = 10;
	}
	$terms_args['number'] = $limit;
}
$terms = get_terms( $terms_args );
if ( ! $terms || is_wp_error( $terms ) ) {
	return;
}

$category_shadow       = get_theme_mod( 'home_catalogcats_shadow', true );
$category_count_at_img = get_theme_mod( 'home_catalogcats_count_at_img' );
$category_show_count   = get_theme_mod( 'home_catalogcats_show_count', true );

$slider_enabled       = get_theme_mod( 'home_catalogcats_slider_enabled', true );
$slides_count         = get_theme_mod( 'home_catalogcats_count_slides', 5 );
$slider_speed         = get_theme_mod( 'home_catalogcats_slider_speed', 5 );
$slider_speed         = $slider_speed * 1000;
$slider_dots          = get_theme_mod( 'home_catalogcats_slider_dots', false ) ? 'true' : 'false';
$slider_arrows        = get_theme_mod( 'home_catalogcats_slider_arrow', true ) ? 'true' : 'false';
$slider_arrows_mobile = get_theme_mod( 'home_catalogcats_slider_arrow_mobile', true ) ? '' : '_hide-arrows-mobile';

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_catalogcats_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_catalogcats_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class = 'wescle-categories wescle-categories-noslider';
if ( $slider_enabled ) {
	$section_class = 'wescle-categories';
}
$section_position = get_theme_mod( 'home_catalogcats_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}

if ( ! $category_shadow ) {
	$section_class .= ' _without-shadow';
}
if ( $category_count_at_img ) {
	$section_class .= ' _count-at-img';
}
?>
<div class="<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_catalogcats_image_bg' ); ?>
    <div class="container">
		<?php include get_template_directory() . '/template-parts/home/catalogcats-container.php'; ?>
    </div>
</div>
