<div class="slider-wrapper <?php echo $slider_arrows_mobile; ?>">
    <div class="wescle-categories__header _section-about">
        <div class="wescle-categories__about">
			<?php
			if ( $title ) {
				printf( '<%1$s class="wescle-categories__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
			}
			?>
			<?php if ( $text ) { ?>
                <div class="wescle-categories__text"><?php echo $text; ?></div>
			<?php } ?>
        </div>
		<?php if ( $link_url && $link_text ) { ?>
            <a class="wescle-categories__link" href="<?php echo $link_url; ?>"><?php echo $link_text; ?></a>
		<?php } ?>
		<?php if ( $slider_enabled && $slider_arrows === 'true' ) { ?>
            <div class="wescle-categories__buttons slider-buttons">
                <button class="slider-buttons__item slider-buttons__item_prev" type="button">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(180deg); -webkit-transform: rotate(180deg); transform: rotate(180deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                        <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                    </svg>
                </button>
                <button class="slider-buttons__item slider-buttons__item_next" type="button">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 42 42">
                        <path fill-rule="evenodd" d="M11 38.32L28.609 21L11 3.68L13.72 1L34 21.01L13.72 41z" fill="white"></path>
                    </svg>
                </button>
            </div>
		<?php } ?>
    </div>
	<?php if ( $slider_enabled ) { ?>
        <div class="wescle-categories__slider" data-slides="<?php echo $slides_count; ?>" data-autoplay-speed="<?php echo $slider_speed; ?>" data-dots="<?php echo $slider_dots; ?>" data-arrows="<?php echo $slider_arrows; ?>">
			<?php foreach ( $terms as $term ) { ?>
                <div class="wescle-categories__slide">
                    <a class="wescle-categories-item" href="<?php echo get_term_link( $term ); ?>">
                        <div class="wescle-categories-item__image">
							<?php wescle_categories_item_image( $term ); ?>
							<?php if ( $category_show_count && $category_count_at_img ) { ?>
                                <div class="wescle-categories-item__count"><?php echo $term->count; ?></div>
							<?php } ?>
                        </div>
                        <div class="wescle-categories-item__body">
							<?php if ( $category_show_count && ! $category_count_at_img ) { ?>
                                <div class="wescle-categories-item__count"><?php echo $term->count; ?></div>
							<?php } ?>
                            <div class="wescle-categories-item__title"><?php echo $term->name; ?></div>
                        </div>
                    </a>
                </div>
			<?php } ?>
        </div>
	<?php } else { ?>
        <div class="wescle-categories__grid _grid-<?php echo $slides_count; ?>">
			<?php foreach ( $terms as $term ) { ?>
                <a class="wescle-categories-item" href="<?php echo get_term_link( $term ); ?>">
                    <div class="wescle-categories-item__image">
						<?php wescle_categories_item_image( $term ); ?>
						<?php if ( $category_show_count && $category_count_at_img ) { ?>
                            <div class="wescle-categories-item__count"><?php echo $term->count; ?></div>
						<?php } ?>
                    </div>
                    <div class="wescle-categories-item__body">
						<?php if ( $category_show_count && ! $category_count_at_img ) { ?>
                            <div class="wescle-categories-item__count"><?php echo $term->count; ?></div>
						<?php } ?>
                        <div class="wescle-categories-item__title"><?php echo $term->name; ?></div>
                    </div>
                </a>
			<?php } ?>
        </div>
	<?php } ?>
</div>