<?php
if ( ! get_theme_mod( 'module_catalog_enabled' ) ) {
	return;
}

if ( is_front_page() ) {
	if ( ! get_theme_mod( 'module_catalog_enabled_home', true ) ) {
		return;
	}
}

$title      = get_theme_mod( 'module_catalog_title', Helper::get_default_theme_data( 'module_catalog_title' ) );
$title_type = get_theme_mod( 'module_catalog_title_type', 'div' );
$text       = get_theme_mod( 'module_catalog_text' );
$link       = '';
$link_id    = get_theme_mod( 'module_catalog_link_id', 0 );
if ( $link_id ) {
	$link = get_permalink( $link_id );
}
$link_text = get_theme_mod( 'module_catalog_link_text', Helper::get_default_theme_data( 'module_catalog_link_text' ) );
$more_text = get_theme_mod( 'module_catalog_more_text', Helper::get_default_theme_data( 'module_catalog_more_text' ) );

$module_catalog_tabs = get_theme_mod( 'module_catalog_tabs', [] );
if ( ! $module_catalog_tabs ) {
	return;
}

$style_bg = '';
if ( $color_bg = get_theme_mod( 'module_catalog_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'module_catalog_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_catalog_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}

?>
<div class="wescle-transport<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'module_catalog_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="wescle-transport__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text || $link ) { ?>
            <div class="wescle-transport__about _section-about">
				<?php if ( $text ) { ?>
                    <div class="_section-about__text"><?php echo $text; ?></div>
				<?php } ?>
				<?php if ( $link && $link_text ) { ?>
                    <a class="wescle-transport__link" href="<?php echo $link; ?>"><?php echo esc_html( $link_text ); ?></a>
				<?php } ?>
            </div>
		<?php } ?>
		<?php
		$args = [
			'module_catalog_tabs' => $module_catalog_tabs,
			'more_text'           => $more_text,
		];
		get_template_part( 'template-parts/home/catalog-tabs', null, $args );
		?>
    </div>
</div>
