<?php
$module_catalog_tabs = $args['module_catalog_tabs'] ?? [];
$more_text           = $args['more_text'] ?? '';
?>
<div class="_tabs">
	<?php if ( count( $module_catalog_tabs ) > 1 ) { ?>
        <div class="_tabs-nav">
			<?php
			foreach ( $module_catalog_tabs as $key => $catalog_tab ) {
				$class_active = $key == 0 ? '_active' : '';
				echo '<button class="btn btn-main _tabs-item ' . $class_active . '" type="button">' . $catalog_tab['catalog_tab_title'] . '</button>';
			}
			?>
        </div>
	<?php } ?>
    <div class="_tabs-body">
		<?php
		foreach ( $module_catalog_tabs as $key => $catalog_tab ) {
			$class_active = $key == 0 ? '_active' : '';

			$posts_per_page = $catalog_tab['catalog_tab_limit'];
			$args           = [
				'post_type'      => 'catalog_item',
				'post_status'    => 'publish',
				'posts_per_page' => $posts_per_page,
				'tax_query'      => [],
				'orderby'        => [ 'menu_order' => 'ASC', 'date' => 'DESC' ],
			];

			$cat_include   = $catalog_tab['catalog_tab_category'];
			$posts_include = $catalog_tab['catalog_tab_item_ids'] ? array_map( 'trim', explode( ',', $catalog_tab['catalog_tab_item_ids'] ) ) : [];

			if ( $posts_include && $posts_include[0] ) {
				$args['post__in']       = $posts_include;
				$args['posts_per_page'] = count( $posts_include );
				$args['orderby']        = 'post__in';
			}
            elseif ( $cat_include && $cat_include[0] ) {
				$args['tax_query'][] = [
					'taxonomy' => 'catalogcat_wescle',
					'terms'    => $cat_include,
				];
			}
			$query_catalog = new WP_Query( $args );
			$catalog_posts = $query_catalog->posts;
			?>
            <div class="_tabs-block <?php echo $class_active; ?>">
                <div class="wescle-transport__grid">
					<?php
					foreach ( $catalog_posts as $post ) {
						setup_postdata( $post );

						get_template_part( 'template-parts/content/catalog-item' );
					}
					wp_reset_postdata();
					?>
                </div>
				<?php if ( $more_text && $query_catalog->max_num_pages > 1 ) { ?>
                    <div class="wescle-transport__more">
                        <a class="btn btn-main btn-catalog-more" href="#" data-paged="1" data-args="<?php echo htmlspecialchars( json_encode( $query_catalog->query_vars ), ENT_QUOTES, 'UTF-8' ); ?>"><?php echo $more_text; ?></a>
                    </div>
				<?php } ?>
            </div>
			<?php
		}
		?>
    </div>
</div>