<?php
$block_enabled = get_theme_mod( 'home_benefit_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_benefit_title' );
$title_type = get_theme_mod( 'home_benefit_title_type', 'div' );

$text  = get_theme_mod( 'home_benefit_text' );
$items = get_theme_mod( 'home_benefit_items', [] );

$title_price = get_theme_mod( 'home_benefit_title2' );
$price1      = get_theme_mod( 'home_benefit_price1' );
$price2      = get_theme_mod( 'home_benefit_price2' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_benefit_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_benefit_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_benefit_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="benefit<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_benefit_image_bg' ); ?>
    <div class="container">
	    <?php
	    if ( $title ) {
		    printf( '<%1$s class="benefit__title title title_divider title_center" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
	    }
	    ?>
	    <?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="_section-about__text"><?php echo $text; ?></div>
            </div>
	    <?php } ?>
	    <?php if ( $price1 ) { ?>
            <div class="benefit__buy">
			    <?php if ( $title_price ) { ?>
                    <span class="benefit__buy-title"><?php echo $title_price; ?></span>
			    <?php } ?>
                <div class="benefit__price">
                    <span class="benefit__price-current"><?php echo $price1; ?></span>
				    <?php if ( $price2 ) { ?>
                        <span class="benefit__price-old"><?php echo $price2; ?></span>
				    <?php } ?>
                </div>
            </div>
	    <?php } ?>
		<?php if ( $items ) { ?>
            <div class="benefit__row">
				<?php foreach ( $items as $item ) { ?>
                    <div class="benefit__col">
                        <div class="benefit-item">
							<?php if ( $item['image_id'] ) { ?>
                                <div class="benefit-item__img">
									<?php echo wp_get_attachment_image( $item['image_id'], 'medium' ); ?>
                                </div>
							<?php } ?>
							<?php if ( $item['title'] ) { ?>
                                <div class="benefit-item__title"><?php echo $item['title']; ?></div>
							<?php } ?>
							<?php if ( $item['text'] ) { ?>
                                <div class="benefit-item__text"><?php echo nl2br( $item['text'] ); ?></div>
							<?php } ?>
							<?php if ( $item['price'] ) { ?>
                                <div class="benefit-item__would-spend"><?php echo $item['price']; ?></div>
							<?php } ?>
                        </div>
                    </div>
				<?php } ?>
            </div>
		<?php } ?>
    </div>
</div>