<?php
$block_enabled = get_theme_mod( 'home_advantages_v3_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$advantages_items = get_theme_mod( 'home_advantages_v3_items', [] );
if ( ! $advantages_items ) {
	return;
}

$title      = get_theme_mod( 'home_advantages_v3_title' );
$title_type = get_theme_mod( 'home_advantages_v3_title_type', 'div' );
$text       = get_theme_mod( 'home_advantages_v3_text' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_advantages_v3_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_advantages_v3_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_advantages_v3_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="advantages-v3<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_advantages_v3_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="advantages-v3__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="_section-about__text">
					<?php echo $text; ?>
                </div>
            </div>
		<?php } ?>
        <div class="advantages-v3__grid">
			<?php foreach ( $advantages_items as $key => $item ) {
				$number = isset( $item['number'] ) && $item['number'] ? $item['number'] : ( $key + 1 );
				?>
                <div class="advantages-v3__row _anim-item _anim-no-hide">
                    <div class="advantages-v3__item">
                        <div class="advantages-v3-block">
							<?php if ( $item['title'] ) { ?>
                                <div class="advantages-v3-block__title"><?php echo $item['title']; ?></div>
							<?php } ?>
							<?php if ( $item['text'] ) { ?>
                                <div class="advantages-v3-block__text"><?php echo nl2br( $item['text'] ); ?></div>
							<?php } ?>
                            <div class="advantages-v3-triangle"></div>
                        </div>
                    </div>
                    <div class="advantages-v3__count">
                        <div class="advantages-v3-count"><span><?php echo $number; ?></span></div>
                        <div class="advantages-v3-line"><span></span></div>
                    </div>
                    <div class="advantages-v3__empty"></div>
                </div>
			<?php } ?>
        </div>
    </div>
</div>