<?php
$block_enabled = get_theme_mod( 'home_advantages_v2_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$advantages_items = get_theme_mod( 'home_advantages_v2_items', [] );
if ( ! $advantages_items ) {
	return;
}

$title      = get_theme_mod( 'home_advantages_v2_title' );
$title_type = get_theme_mod( 'home_advantages_v2_title_type', 'div' );
$subtitle   = get_theme_mod( 'home_advantages_v2_subtitle' );
if ( $subtitle ) {
	$title .= ' <strong>' . $subtitle . '</strong>';
}

$image_id = get_theme_mod( 'home_advantages_v2_image' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_advantages_v2_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_advantages_v2_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_advantages_v2_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="advantages-v2<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_advantages_v2_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="advantages-v2__title title title_divider title_center" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
        <div class="advantages-v2__grid">
			<?php foreach ( $advantages_items as $item ) { ?>
				<?php
				$tag_open  = '<div class="advantages-v2-item">';
				$tag_close = '</div>';
				if ( isset( $item['link'] ) && $item['link'] ) {
					$tag_open  = '<a href="' . $item['link'] . '" class="advantages-v2-item">';
					$tag_close = '</a>';
				}
				?>
				<?php echo $tag_open; ?>
                <div class="advantages-v2-item__img">
					<?php
					if ( $item['image_id'] ) {
						echo wp_get_attachment_image( $item['image_id'], 'medium' );
					}
					?>
                </div>
                <div class="advantages-v2-item__body">
                    <div class="advantages-v2-item__title"><?php echo $item['title']; ?></div>
                    <div class="advantages-v2-item__text"><?php echo nl2br( $item['text'] ); ?></div>
                </div>
				<?php echo $tag_close; ?>
				<?php
				break;
			}
			?>
            <div class="advantages-v2-item advantages-v2-item_big">
                <div class="advantages-v2-item__bg">
					<?php echo wp_get_attachment_image( $image_id, 'medium_large' ); ?>
                </div>
            </div>
			<?php foreach ( $advantages_items as $key => $item ) { ?>
				<?php
				if ( $key == 0 ) {
					continue;
				}
				?>
				<?php
				$tag_open  = '<div class="advantages-v2-item">';
				$tag_close = '</div>';
				if ( isset( $item['link'] ) && $item['link'] ) {
					$tag_open  = '<a href="' . $item['link'] . '" class="advantages-v2-item">';
					$tag_close = '</a>';
				}
				?>
				<?php echo $tag_open; ?>
                <div class="advantages-v2-item__img">
					<?php
					if ( $item['image_id'] ) {
						echo wp_get_attachment_image( $item['image_id'], 'medium' );
					}
					?>
                </div>
                <div class="advantages-v2-item__body">
                    <div class="advantages-v2-item__title"><?php echo $item['title']; ?></div>
                    <div class="advantages-v2-item__text"><?php echo nl2br( $item['text'] ); ?></div>
                </div>
				<?php echo $tag_close; ?>
			<?php } ?>
        </div>
    </div>
</div>