<?php
$block_enabled = get_theme_mod( 'home_advantages_enabled', false );
if ( ! $block_enabled ) {
	return;
}

$advantages_items = get_theme_mod( 'home_advantages_items', [] );
if ( ! $advantages_items ) {
	return;
}

$title      = get_theme_mod( 'home_advantages_title' );
$title_type = get_theme_mod( 'home_advantages_title_type', 'div' );
$text       = get_theme_mod( 'home_advantages_text' );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_advantages_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_advantages_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_advantages_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="advantages advantages-first<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_advantages_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="advantages__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
		<?php if ( $text ) { ?>
            <div class="_section-about">
                <div class="_section-about__text">
					<?php echo $text; ?>
                </div>
            </div>
		<?php } ?>
        <div class="advantages__row advantages__count-<?php echo count( $advantages_items ); ?>">
			<?php
			foreach ( $advantages_items as $item ) {
				if ( ! isset( $item['link'] ) ) {
					$item['link'] = '';
				}

				if ( ! $item['link'] ) {
					$block_open  = '<div class="advantages-item">';
					$block_close = '</div>';
				}
				else {
					$block_open  = '<a class="advantages-item" href="' . esc_url( $item['link'] ) . '">';
					$block_close = '</a>';
				}

				$img = '';
				if ( $item['image_id'] ) {
					$advantages_maxwidth = get_theme_mod( 'home_advantages_maxwidth', '50' );
					$img_src             = wp_get_attachment_image_src( $item['image_id'], 'thumbnail' );
					if ( $img_src ) {
						$img = '<img src="' . $img_src[0] . '" alt="' . esc_attr( $item['title'] ) . '" loading="lazy" width="' . $advantages_maxwidth . '" height="' . $advantages_maxwidth . '">';
					}
					else {
						$img = '';
					}
				}

				$style = '';
				if ( $item['bg_color'] ) {
					$style = 'style="background-color:' . $item['bg_color'] . '"';
				}
				?>
                <div class="advantages__col">
					<?php echo $block_open; ?>
					<?php if ( $img ) { ?>
                        <div class="advantages-item__img" <?php echo $style; ?>>
							<?php echo $img; ?>
                        </div>
					<?php } ?>
                    <div class="advantages-item__body">
                        <div class="advantages-item__title"><?php echo nl2br( $item['title'] ); ?></div>
                        <div class="advantages-item__text"><?php echo nl2br( $item['text'] ); ?></div>
                    </div>
					<?php echo $block_close; ?>
                </div>
			<?php } ?>
        </div>
    </div>
</div>