<?php
$block_enabled = get_theme_mod( 'home_about2_enabled' );
if ( ! $block_enabled ) {
	return;
}

$title       = get_theme_mod( 'home_about2_title' );
$title_type  = get_theme_mod( 'home_about2_title_type', 'div' );
$about_items = get_theme_mod( 'home_about2_items', [] );
$image_id    = intval( get_theme_mod( 'home_about2_image' ) );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_about2_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_about2_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_about2_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="about-2<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_about2_image_bg' ); ?>
    <div class="container">
		<?php
		if ( $title ) {
			printf( '<%1$s class="about-2__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
		}
		?>
        <div class="about-2__grid">
            <div class="about-2__col">
				<?php if ( $about_items ) { ?>
                    <div class="about-2__about">
                        <ul class="about-2-advantages">
							<?php foreach ( $about_items as $item ) { ?>
                                <li class="about-2-advantages__item">
									<?php if ( $item['image'] ) { ?>
                                        <div class="about-2-advantages__item-img">
											<?php echo wp_get_attachment_image( $item['image'], 'medium' ); ?>
                                        </div>
									<?php } ?>
                                    <span><?php echo $item['title']; ?></span>
                                </li>
							<?php } ?>
                        </ul>
                    </div>
				<?php } ?>
            </div>
			<?php if ( $image_id && ( $img = wp_get_attachment_image( $image_id, 'medium_large' ) ) ) { ?>
                <div class="about-2__col">
					<?php
					$div_class = 'about-2__img';
					if ( get_theme_mod( 'home_about2_image_object_fit' ) ) {
						$div_class .= ' _cover';
					}
					?>
                    <div class="<?php echo $div_class; ?>">
						<?php echo $img; ?>
                    </div>
                </div>
			<?php } ?>
        </div>
    </div>
</div>