<?php
$block_enabled = get_theme_mod( 'home_about_enabled', true );
if ( ! $block_enabled ) {
	return;
}

$title      = get_theme_mod( 'home_about_title', Helper::get_default_theme_data( 'home_about_title' ) );
$title_type = get_theme_mod( 'home_about_title_type', 'div' );
$text       = get_theme_mod( 'home_about_text', Helper::get_default_theme_data( 'home_about_text' ) );

if ( ! $text && ! $title ) {
	return;
}

$link    = '';
$link_id = get_theme_mod( 'home_about_link_id', 0 );
if ( $link_id ) {
	$link = get_permalink( $link_id );
}
$button_text = get_theme_mod( 'home_about_button_text', __( 'Подробнее', 'wescle' ) );
$image_id    = intval( get_theme_mod( 'home_about_image' ) );

$style_bg = '';
if ( $color_bg = get_theme_mod( 'home_about_color_bg' ) ) {
	$style_bg = 'style="background-color:' . $color_bg . ';"';
}

$style_title = '';
if ( $color = get_theme_mod( 'home_about_color_title' ) ) {
	$style_title = 'style="color:' . $color . ';"';
}

$btn_flare = '';
if ( get_theme_mod( 'about_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}

$section_class    = '';
$section_position = get_theme_mod( 'home_about_position_content', 'default' );
if ( 'default' != $section_position ) {
	$section_class .= ' _section-' . $section_position;
}
?>
<div class="about<?php echo $section_class; ?>" <?php echo $style_bg; ?>>
	<?php echo wescle_home_block_bg_image( 'home_about_image_bg' ); ?>
    <div class="container">
        <div class="row about__row">
            <div class="col about__col">
				<?php
				if ( $title ) {
					printf( '<%1$s class="about__title title title_divider" %2$s>' . $title . '</%1$s>', $title_type, $style_title );
				}
				?>

				<?php
	            $text = str_replace( [ '<p>' ], [ '<p class="about__text">' ], wpautop( $text ) );
	            $text = str_replace( [ '<ul>', '<ol>' ], [ '<ul class="about__text">', '<ol class="about__text">' ], $text );
	            echo $text;
	            ?>

	            <?php if ( $link && $button_text ) { ?>
                    <a class="services__btn btn btn-main <?php echo $btn_flare; ?>" href="<?php echo $link; ?>"><?php echo esc_html( $button_text ); ?></a>
	            <?php } ?>
            </div>
	        <?php if ( $image_id && ( $img = wp_get_attachment_image( $image_id, 'medium_large' ) ) ) { ?>
                <div class="col about__col">
                    <div class="about__image">
				        <?php echo $img; ?>
                    </div>
                </div>
	        <?php } ?>
        </div>
    </div>
</div>