<?php
if ( ! Helper::is_header_tabs() ) {
	return;
}

$header_bar_tabs_menu = get_theme_mod( 'header_bar_tabs_menu', [] );
?>
<div class="header__head">
    <div class="container">
		<?php if ( $header_bar_tabs_menu ) { ?>
            <div class="header-tabs-nav">
				<?php foreach ( $header_bar_tabs_menu as $key => $item ) { ?>
					<?php
					if ( ! $item['menu_id'] ) {
						continue;
					}
					$class_active = $key == 0 ? '_active' : '';
					?>
                    <button class="_tabs-item <?php echo $class_active; ?>" type="button"><?php echo $item['title']; ?></button>
				<?php } ?>
            </div>
		<?php } ?>
		<?php
		$sort_blocks = get_theme_mod( 'header_block_sortable', [
			'address',
			'phone',
			'button',
		] );

		if ( in_array( 'address', $sort_blocks ) ) {
			get_template_part( 'template-parts/header/address', '', [ 'top_tabs' => true ] );
		}
		if ( in_array( 'phone', $sort_blocks ) ) {
			get_template_part( 'template-parts/header/phone', '', [ 'top_tabs' => true ] );
		}
		get_template_part( 'template-parts/header/buddypress', 'links' );
		?>
		<?php get_template_part( 'template-parts/header/email' ); ?>
		<?php get_template_part( 'template-parts/header/socials', 'top_banner', [ 'top_bar_id' => 'header_bar', 'top_bar_class' => 'bar' ] ); ?>
    </div>
</div>