<?php
if ( ! get_theme_mod( 'top_bar_enabled' ) ) {
	return;
}
?>
<div class="top-bar">
    <div class="container">
        <div class="top-bar__row">
            <div class="top-bar__col">
				<?php
				if ( has_nav_menu( 'top_bar' ) ) { ?>
                    <nav class="top-bar__nav">
                        <ul class="top-bar__list">
							<?php
							require get_template_directory() . '/includes/app/MenuTopBarWalker.php';

							wp_nav_menu(
								array(
									'container'      => '',
									'items_wrap'     => '%3$s',
									'theme_location' => 'top_bar',
									'walker'         => new MenuTopBarWalker()
								)
							);
							?>
                        </ul>
                    </nav>
				<?php } ?>
            </div>
            <div class="top-bar__col">
                <div class="top-bar__actions">
			        <?php get_template_part( 'template-parts/header/socials', 'top_banner' ); ?>
			        <?php
			        if ( get_theme_mod( 'top_bar_store_enabled' ) ) {
				        get_template_part( 'template-parts/header/navigation', 'store' );
			        }
			        ?>
                </div>
            </div>
        </div>
    </div>
</div>