<?php
if ( isset( $_COOKIE['top_banner'] ) && $_COOKIE['top_banner'] == 'close' ) {
	return;
}

$slides   = Helper::get_slides_top_banner();
$bg_color = get_theme_mod( 'top_banner_bg', '#0088cc' );
$color    = get_theme_mod( 'top_banner_color', '#ffffff' );

if ( $slides ) {
	$opacity        = 'opacity:0;';
	$bg_color_style = '';
	$color_style    = '';

	if ( $bg_color != '#0088cc' ) {
		$bg_color_style = 'background-color:' . $bg_color . ';';
	}
	if ( $color != '#ffffff' ) {
		$color_style = 'color:' . $color . ';';
	}
	$style = 'style="' . $opacity . $bg_color_style . $color_style . '"';
	?>
    <div class="top-banner" <?php echo $style; ?>>
        <button class="btn-close" type="button">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                <path fill="#626262" d="M13.41 12l4.3-4.29a1 1 0 1 0-1.42-1.42L12 10.59l-4.29-4.3a1 1 0 0 0-1.42 1.42l4.3 4.29l-4.3 4.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0l4.29-4.3l4.29 4.3a1 1 0 0 0 1.42 0a1 1 0 0 0 0-1.42z"></path>
            </svg>
        </button>
        <div class="container">
            <div class="top-banner__slider">
				<?php
				$button_class = 'top-banner__link btn btn-main';
				if ( get_theme_mod( 'topbanner_button_type' ) == 'animation' ) {
					$button_class .= ' btn-flare';
				}

				foreach ( $slides as $slide ) {
					if ( ! $slide['text'] ) {
						continue;
					}
					?>
                    <div class="top-banner__slide">
                        <div class="top-banner__item">
                            <div class="top-banner__text"><?php echo $slide['text']; ?></div>
							<?php if ( $slide['button_link'] ) { ?>
								<?php
								$target = '';
								if ( ! isset( $slide['target_blank'] ) || $slide['target_blank'] ) {
									$target = 'target="_blank"';
								}

								$link_class = $button_class;
								if ( strpos( $slide['button_link'], '#wescle-modal' ) !== false ) {
									$link_class .= ' _popup-link';
								}
								?>
                                <a class="<?php echo $link_class; ?>" href="<?php echo $slide['button_link']; ?>" <?php echo $target; ?>><span><?php echo $slide['button_text']; ?></span>
                                    <svg class="feather feather-link" xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewbox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round">
                                        <path d="M10 13a5 5 0 0 0 7.54.54l3-3a5 5 0 0 0-7.07-7.07l-1.72 1.71"></path>
                                        <path d="M14 11a5 5 0 0 0-7.54-.54l-3 3a5 5 0 0 0 7.07 7.07l1.71-1.71"></path>
                                    </svg>
                                </a>
							<?php } ?>
                        </div>
                    </div>
				<?php } ?>
            </div>
        </div>
    </div>
<?php } ?>