<?php
$top_bar_id    = $args['top_bar_id'] ?? 'top_bar';
$top_bar_class = $args['top_bar_class'] ?? 'top-bar';

if ( ! get_theme_mod( $top_bar_id . '_socials_enabled', true ) ) {
	return;
}

$limit_count = get_theme_mod( $top_bar_id . '_socials_count', 4 );
ob_start();
get_template_part( 'template-parts/footer/socials' );
$html = ob_get_clean();

$link_count = substr_count( $html, '</li>' );
$html       = preg_replace( '~<ul.+?>~', '<div class="socials-' . $top_bar_class . '__list">', $html );
$html       = str_replace( '<li class="socials__item ', '<div class="socials-' . $top_bar_class . '__item ', $html );
$html       = str_replace( [ '</li>', '</ul>' ], '</div>', $html );
$html       = str_replace( 'socials__link', 'socials-' . $top_bar_class . '__link', $html );
?>
<div class="socials-<?php echo $top_bar_class; ?>" data-visible-count="<?php echo $limit_count; ?>">
	<?php echo $html; ?>
	<?php if ( $link_count > $limit_count ) { ?>
        <div class="socials-<?php echo $top_bar_class; ?>__dropdown _dropdown">
            <button class="socials-<?php echo $top_bar_class; ?>__btn _dropdown-btn _hide" type="button" aria-label="Open socials dropdown">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" role="img" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                    <g fill="none">
                        <path d="M17 2.498a3.502 3.502 0 1 1-2.597 5.851l-4.558 2.604a3.5 3.5 0 0 1 0 2.093l4.557 2.606a3.502 3.502 0 1 1-.745 1.302L9.1 14.347a3.502 3.502 0 1 1 0-4.698l4.557-2.604A3.502 3.502 0 0 1 17 2.498zm0 13.5a2.002 2.002 0 1 0 0 4.004a2.002 2.002 0 0 0 0-4.004zm-10.498-6a2.002 2.002 0 1 0 0 4.004a2.002 2.002 0 0 0 0-4.004zm10.498-6a2.002 2.002 0 1 0 0 4.004a2.002 2.002 0 0 0 0-4.004z" fill="currentColor"></path>
                    </g>
                </svg>
            </button>
            <div class="socials-<?php echo $top_bar_class; ?>__dropdown-wrapper _dropdown-body">
                <div class="socials-<?php echo $top_bar_class; ?>__dropdown-body"></div>
            </div>
        </div>
	<?php } ?>
</div>

