<?php
if ( ! get_theme_mod( 'module_preloader_enabled' ) ) {
	return;
}
$img_light   = get_theme_mod( 'module_preloader_bg_light', 0 );
$img_dark    = get_theme_mod( 'module_preloader_bg_dark', 0 );
$show_logo   = get_theme_mod( 'module_preloader_logo_enabled' );
$img_logo    = get_theme_mod( 'module_preloader_logo' );
if ( ! $img_logo ) {
	$img_logo = get_theme_mod( 'custom_logo' );
}
$animation   = get_theme_mod( 'module_preloader_animation' );
$img_custom  = get_theme_mod( 'module_preloader_custom_image', 0 );
?>
<div class="_preloader">
	<?php if ( $img_light ) { ?>
        <img class="_preloader__bg" src="<?php echo wp_get_attachment_url( $img_light ); ?>" alt="" loading="lazy">
	<?php } ?>
	<?php if ( $img_dark ) { ?>
        <img class="_preloader__bg-dark" src="<?php echo wp_get_attachment_url( $img_dark ); ?>" alt="" loading="lazy">
	<?php } ?>
    <div class="_preloader__body">
		<?php if ( $show_logo && $img_logo ) { ?>
            <div class="_preloader__img">
                <img src="<?php echo wp_get_attachment_url( $img_logo ); ?>" alt="" loading="lazy">
            </div>
		<?php } ?>

		<?php if ( ! $img_custom ) { ?>
			<?php if ( 1 == $animation ) { ?>
                <div class="_loading-spinner-dual-ball">
                    <div class="_loading-spinner-dual-ball__body">
                        <div></div>
                        <div></div>
                        <div></div>
                    </div>
                </div>
			<?php } ?>
			<?php if ( 2 == $animation ) { ?>
                <div class="_loading-spinner">
                    <div class="_loading-spinner__body">
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                    </div>
                </div>
			<?php } ?>
			<?php if ( 3 == $animation ) { ?>
                <div class="_loading-spinner-dual-ring">
                    <div class="_loading-spinner-dual-ring__body">
                        <div></div>
                        <div>
                            <div></div>
                        </div>
                    </div>
                </div>
			<?php } ?>
			<?php if ( 4 == $animation ) { ?>
                <div class="_loading-spinner-bean-eater">
                    <div class="_loading-spinner-bean-eater__body">
                        <div>
                            <div></div>
                            <div></div>
                            <div></div>
                        </div>
                        <div>
                            <div></div>
                            <div></div>
                            <div></div>
                        </div>
                    </div>
                </div>
			<?php } ?>
			<?php if ( 5 == $animation ) { ?>
                <div class="_loading-spinner-infinity">
                    <svg xmlns="http://www.w3.org/2000/svg" viewbox="0 0 100 100" preserveaspectratio="xMidYMid">
                        <path fill="none" stroke-width="8" stroke-dasharray="42.76482137044271 42.76482137044271" d="M24.3 30C11.4 30 5 43.3 5 50s6.4 20 19.3 20c19.3 0 32.1-40 51.4-40 C88.6 30 95 43.3 95 50s-6.4 20-19.3 20C56.4 70 43.6 30 24.3 30z" stroke-linecap="round" style="transform:scale(0.8);transform-origin:50px 50px"></path>
                        <animate attributename="stroke-dashoffset" repeatcount="indefinite" dur="1s" keytimes="0;1" values="0;256.58892822265625"></animate>
                    </svg>
                </div>
			<?php } ?>
			<?php if ( 6 == $animation ) { ?>
                <div class="_loading-spinner-blocks">
                    <div class="_loading-spinner-blocks__body">
                        <div style="left:38px;top:38px;animation-delay:0s"></div>
                        <div style="left:80px;top:38px;animation-delay:0.125s"></div>
                        <div style="left:122px;top:38px;animation-delay:0.25s"></div>
                        <div style="left:38px;top:80px;animation-delay:0.875s"></div>
                        <div style="left:122px;top:80px;animation-delay:0.375s"></div>
                        <div style="left:38px;top:122px;animation-delay:0.75s"></div>
                        <div style="left:80px;top:122px;animation-delay:0.625s"></div>
                        <div style="left:122px;top:122px;animation-delay:0.5s"></div>
                    </div>
                </div>
			<?php } ?>
			<?php if ( 7 == $animation ) { ?>
                <div class="_loading-spinner-ellipsis">
                    <div class="_loading-spinner-ellipsis__body">
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                        <div></div>
                    </div>
                </div>
			<?php } ?>
			<?php if ( 8 == $animation ) { ?>
                <div class="_loading-spinner-gear">
                    <div class="_loading-spinner-gear__body">
                        <div>
                            <div></div>
                            <div></div>
                            <div></div>
                            <div></div>
                            <div></div>
                            <div></div>
                        </div>
                    </div>
                </div>
			<?php } ?>
			<?php if ( 9 == $animation ) { ?>
                <div class="_loading-spinner-pulse">
                    <div class="_loading-spinner-pulse__body">
                        <div></div>
                        <div></div>
                        <div></div>
                    </div>
                </div>
			<?php } ?>
			<?php if ( 10 == $animation ) { ?>
                <div class="_loading-spinner-ripple">
                    <div class="_loading-spinner-ripple__body">
                        <div></div>
                        <div></div>
                    </div>
                </div>
			<?php } ?>
		<?php } else { ?>
            <div class="_loading-spinner-custom">
				<?php echo wp_get_attachment_image( $img_custom, 'medium' ); ?>
            </div>
		<?php } ?>
    </div>
</div>