<?php
$is_top_tabs  = $args['top_tabs'] ?? false;
$phone        = get_theme_mod( 'phone_primary', Helper::get_default_theme_data( 'phone_primary' ) );
$phone_type   = get_theme_mod( 'phone_type', Helper::get_default_theme_data( 'phone_type' ) );
$phone_login  = get_theme_mod( 'phone_username', '' );
$work_time    = get_theme_mod( 'work_time', Helper::get_default_theme_data( 'work_time' ) );
$working_days = get_theme_mod( 'working_days_list', Helper::get_default_theme_data( 'working_days_list' ) );
$phone_others = get_theme_mod( 'phone_others', Helper::get_default_theme_data( 'phones' ) );

$is_phone_email = get_theme_mod( 'phone_email', false );
$email          = get_theme_mod( 'email_primary', Helper::get_default_theme_data( 'email_primary' ) );

if ( ! $phone && ! $work_time ) {
	return;
}

$div_class_operator = '';
$operator_icon_id   = get_theme_mod( 'phone_icon' );
if ( $operator_icon_id ) {
	$div_class_operator = ' _with-operator';
}
elseif ( isset( $phone_others[0] ) && $phone_others[0]['phone'] ) {
	foreach ( $phone_others as $tel_other ) {
		if ( ! $tel_other['phone'] ) {
			continue;
		}

		$phone_icon = isset( $tel_other['phone_icon'] ) ? $tel_other['phone_icon'] : '';
		if ( $phone_icon ) {
			$div_class_operator = ' _with-operator';
			break;
		}
	}
}
?>
<div class="header-top__telephone telephone dropdown-toggle<?php echo $div_class_operator; ?>">
    <button class="telephone__btn btn-telephone">
        <svg class="icon-telephone" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
            <g fill="#626262">
                <path d="M13 8a3 3 0 0 1 3 3a1 1 0 0 0 2 0a5 5 0 0 0-5-5a1 1 0 0 0 0 2z"></path>
                <path d="M13 4a7 7 0 0 1 7 7a1 1 0 0 0 2 0a9 9 0 0 0-9-9a1 1 0 0 0 0 2zm8.75 11.91a1 1 0 0 0-.72-.65l-6-1.37a1 1 0 0 0-.92.26c-.14.13-.15.14-.8 1.38a9.91 9.91 0 0 1-4.87-4.89C9.71 10 9.72 10 9.85 9.85a1 1 0 0 0 .26-.92L8.74 3a1 1 0 0 0-.65-.72a3.79 3.79 0 0 0-.72-.18A3.94 3.94 0 0 0 6.6 2A4.6 4.6 0 0 0 2 6.6A15.42 15.42 0 0 0 17.4 22a4.6 4.6 0 0 0 4.6-4.6a4.77 4.77 0 0 0-.06-.76a4.34 4.34 0 0 0-.19-.73z"></path>
            </g>
        </svg>
    </button>
    <div class="telephone__content">
        <div class="telephone__actions">
			<?php if ( $phone ) { ?>
				<?php
				$phone_link = Helper::phone_number_format( $phone, $phone_type, $phone_login );
				?>
				<?php if ( $phone_type != 'tel' ) { ?>
					<?php
					if ( strpos( $phone_link, '://' ) === false ) {
						echo '<a rel="nofollow" class="social-telephone" href="' . $phone_link . '">';
					}
					else {
						echo '<span class="social-telephone js-link" data-link="' . $phone_link . '">';
					}
					?>
				<?php } ?>

				<?php echo Helper::html_svg_icon( $phone_type ); ?>

				<?php if ( $phone_type != 'tel' ) { ?>
					<?php
					if ( strpos( $phone_link, '://' ) === false ) {
						echo '</a>';
					}
					else {
						echo '</span>';
					}
					?>
				<?php } ?>
                <a rel="nofollow" class="telephone__link" href="<?php echo Helper::phone_number_format( $phone, 'tel', '' ); ?>">
                    <span><?php echo Helper::phone_number_mask( strip_tags( $phone ) ); ?></span>
                </a>
			<?php } ?>
			<?php
			$operator_icon_id = get_theme_mod( 'phone_icon' );
			if ( $operator_icon_id ) {
				$operator_icon = wp_get_attachment_image_src( $operator_icon_id );
				if ( $operator_icon ) {
					echo '<div class="telephone-operator"><img src="' . $operator_icon[0] . '" alt="" loading="lazy"></div>';
                }
			}
			?>
			<?php if ( isset( $phone_others[0] ) && $phone_others[0]['phone'] ) { ?>
                <button class="_arrowUpDown telephone__btn-arrow btn-arrow">
                    <svg class="_arrow-up" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                        <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                            <path d="M30 12L16 24L2 12"></path>
                        </g>
                    </svg>
                    <svg class="_arrow-down" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                        <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                            <path d="M30 12L16 24L2 12"></path>
                        </g>
                    </svg>
                </button>
			<?php } ?>
        </div>
		<?php if ( $work_time && ! $is_top_tabs ) { ?>
            <div class="telephone__schedule schedule"><?php echo $work_time; ?></div>
		<?php } ?>
		<?php
		if ( $working_days && ! $is_top_tabs ) {
			html_working_days( $working_days );
		}
		?>
		<?php if ( $is_phone_email && ! $is_top_tabs ) { ?>
            <div class="telephone__mail"><a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a></div>
		<?php } ?>
    </div>

    <div class="telephone__dropdown dropdown-content">
        <div class="telephones">
			<?php
			foreach ( $phone_others as $tel_other ) {
				if ( ! $tel_other['phone'] ) {
					continue;
				}

				$phone            = $tel_other['phone'];
				$phone_type       = $tel_other['phone_type'];
				$username         = $tel_other['phone_username'];
				$phone_label      = isset( $tel_other['phone_label'] ) ? $tel_other['phone_label'] : '';
				$label_as_link    = isset( $tel_other['phone_label_is_link'] ) ? $tel_other['phone_label_is_link'] : '';
				$operator_icon_id = isset( $tel_other['phone_icon'] ) ? $tel_other['phone_icon'] : '';

				echo '<div class="telephones-wrapper">';

				if ( $phone_type != 'tel' ) {
					$phone_link = Helper::phone_number_format( $phone, $phone_type, $username );
					if ( strpos( $phone_link, '://' ) === false && strpos( $phone_link, '?' ) === false ) {
						echo '<a rel="nofollow" class="social-telephone" href="' . $phone_link . '">' . Helper::html_svg_icon( $phone_type ) . '</a>';
					}
					else {
						echo '<span class="social-telephone js-link" data-link="' . $phone_link . '">' . Helper::html_svg_icon( $phone_type ) . '</span>';
					}
				}
				else {
					echo '<span class="social-telephone">' . Helper::html_svg_icon( $phone_type ) . '</span>';
				}

				if ( $phone_label ) {
					$phone_link  = Helper::phone_number_format( $phone, $phone_type, $username );
					$phone_label = Helper::phone_number_mask( strip_tags( $phone_label ) );
					if ( $label_as_link || $phone_type == 'tel' ) {
						if ( strpos( $phone_link, '://' ) === false && strpos( $phone_link, '?' ) === false ) {
							echo '<a rel="nofollow" class="telephones__link telephones__link1" href="' . $phone_link . '">' . $phone_label . '</a>';
						}
						else {
							echo '<span class="telephones__link telephones__link1 js-link" data-link="' . $phone_link . '">' . $phone_label . '</span>';
						}
					}
					else {
						echo '<span class="telephones__link telephones__link2">' . $phone_label . '</span>';
					}
				}
				else {
					echo '<a rel="nofollow" class="telephones__link telephones__link3" href="' . Helper::phone_number_format( $phone, 'tel', $username ) . '">' . Helper::phone_number_mask( strip_tags( $phone ) ) . '</a>';
				}

				if ( $operator_icon_id ) {
					$operator_icon = wp_get_attachment_image_src( $operator_icon_id );
					echo '<div class="telephone-operator"><img src="' . $operator_icon[0] . '" alt="" loading="lazy"></div>';
				}

				echo '</div>';
			}
			?>
        </div>
    </div>
</div>