<?php
$button_type = isset( $args['button_type'] ) ? $args['button_type'] : 'button';

$categories_data = WsclWoocommerce::get_nav_shop_categories();
if ( $categories_data ) {
	$menu_title = get_theme_mod( 'header_store_menu_title', Helper::get_default_theme_data( 'header_store_menu_label' ) );
	?>
    <div class="vertical-menu">
		<?php if ( $button_type == 'button' ) { ?>
            <button type="button" aria-expanded="false">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                    <path d="M21 6v2H3V6h18zM3 18h18v-2H3v2zm0-5h18v-2H3v2z" fill="#626262"></path>
                </svg>
                <span><?php echo $menu_title; ?></span>
            </button>
		<?php } else { ?>
            <div class="vertical-menu__title"><span><?php echo $menu_title; ?></span></div>
		<?php } ?>
        <div class="vertical-menu__body">
            <ul>
				<?php
				foreach ( $categories_data as $categories_data_item ) {
					if ( ! isset( $categories_data_item['term_name'] ) ) {
						continue;
					}

					$li_class = '';
					if ( $categories_data_item['children'] ) {
						$li_class = 'class="with-arrow"';
					}

					if ( $categories_data_item['term_link'] ) {
						$tag_open  = '<a href="' . $categories_data_item['term_link'] . '">';
						$tag_close = '</a>';
					}
					else {
						$tag_open  = '<span>';
						$tag_close = '</span>';
					}
					?>
                    <li <?php echo $li_class; ?>>
						<?php echo $tag_open; ?>
						<?php echo $categories_data_item['term_img']; ?>
                        <span><?php echo $categories_data_item['term_name']; ?></span>
						<?php echo $tag_close; ?>
						<?php if ( $categories_data_item['children'] ) { ?>
                            <button class="arrow">
                                <svg class="icon-arrow-bottom" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                                    <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                                        <path d="M30 12L16 24L2 12"></path>
                                    </g>
                                </svg>
                            </button>
                            <div class="vertical-submenu">
                                <div class="vertical-submenu-wrap">
									<?php foreach ( $categories_data_item['children'] as $child_item ) {
										if ( $child_item['term_link'] ) {
											$tag_open  = '<a href="' . $child_item['term_link'] . '">';
											$tag_close = '</a>';
										}
										else {
											$tag_open  = '<span>';
											$tag_close = '</span>';
										}
										?>
                                        <div>
                                            <p><?php echo $tag_open; ?><?php echo $child_item['term_name']; ?><?php echo $tag_close; ?></p>
											<?php
											if ( isset( $child_item['children'] ) && $child_item['children'] ) {
												echo '<ul>';
												foreach ( $child_item['children'] as $item ) {
													if ( $item['term_link'] ) {
														$tag_open  = '<a href="' . $item['term_link'] . '">';
														$tag_close = '</a>';
													}
													else {
														$tag_open  = '<span>';
														$tag_close = '</span>';
													}

													echo '<li>' . $tag_open . $item['term_name'] . $tag_close . '</li>';
												}
												echo '</ul>';
											}
											?>
                                        </div>
									<?php } ?>
                                </div>
                            </div>
						<?php } ?>
                    </li>
				<?php } ?>
            </ul>
        </div>
    </div>
<?php } ?>