<?php
require_once get_template_directory() . '/includes/app/MenuTopWalker.php';

$header_bar_tabs_menu = get_theme_mod( 'header_bar_tabs_menu', [] );
?>
<div class="header-tabs-body">
	<?php foreach ( $header_bar_tabs_menu as $key => $item ) { ?>
		<?php
		if ( ! $item['menu_id'] ) {
			continue;
		}
		$class_active = $key === 0 ? '_active' : '';
		?>
        <div class="_tabs-block <?php echo $class_active; ?>">
            <ul class="nav-list navigation__list">
				<?php
				wp_nav_menu(
					array(
						'menu'           => intval( $item['menu_id'] ),
						'container'      => '',
						'items_wrap'     => '%3$s',
						'walker'         => new MenuTopWalker()
					)
				);
				?>
            </ul>
            <ul class="navigation__list navigation-list-yet hide">
                <li class="navigation__item"><a class="navigation__link"><span></span><span></span><span></span></a>
                    <ul class="navigation__sublist navigation-sublist-yet"></ul>
                </li>
            </ul>
        </div>
	<?php } ?>
</div>