<?php
if ( ! Helper::is_woocommerce_active() ) {
	return;
}

if ( ! Helper::is_store( 'header' ) && ! get_theme_mod( 'top_bar_enabled' ) && ! Helper::is_header_tabs() ) {
	return;
}

$sort_blocks = get_theme_mod( 'header_icons_sortable', Helper::get_default_theme_data( 'header_icons_sortable' ) );
if ( ! $sort_blocks ) {
	return;
}
?>
<ul class="navigation-store">
	<?php
	foreach ( $sort_blocks as $key ) {
		switch ( $key ) {
			case 'currency_switcher':
				if ( Helper::is_plugin_active( 'woocommerce-currency-switcher/index.php' ) ) { ?>
                    <li class="navigation-store__woocs">
						<?php echo do_shortcode( '[woocs style="1" show_flags="0"]' ); ?>
                    </li>
					<?php
				}
				break;
			case 'account':
				wescle_login_navigation();
				break;
			case 'compare':
				if ( Helper::is_active_compare() ) {
					?>
                    <li class="_compare"><?php wescle_compare_link(); ?></li>
					<?php
				}
				break;
			case 'wishlist':
				?>
                <li class="navigation-store__wishlist"><?php wescle_wishlist_link(); ?></li>
				<?php
				break;
			case 'cart':
				$header_store_cart_big = get_theme_mod( 'header_store_cart_big' );
				?>
                <li class="navigation-store__cart"><?php echo wescle_cart_link(); ?><?php if ( ! $header_store_cart_big ) {
						the_widget( 'WC_Widget_Cart', 'title=' );
					} ?></li>
				<?php
				break;
		}
	}
	?>
</ul>
