<div class="header-center-2__row">
    <div class="header-center-2__col header-center-2__col_nav">
		<?php if ( has_nav_menu( 'top_bar' ) ) { ?>
            <div class="header__icon-menu icon-menu"><span></span><span></span><span></span></div>
            <nav class="menu">
                <div class="menu__body">
                    <div class="menu__title"><?php echo get_theme_mod( 'header_menu_mobile_label', Helper::get_default_theme_data( 'header_menu_mobile_label' ) ); ?></div>
                    <div class="menu__actions"></div>
                    <div class="menu__content"></div>
                </div>
            </nav>
            <nav class="header-center-2-nav" data-da=".header-center-2 .menu__content, 1024">
                <ul class="header-center-2-nav__list">
					<?php
					wp_nav_menu(
						array(
							'container'      => '',
							'items_wrap'     => '%3$s',
							'theme_location' => 'top_bar',
						)
					);
					?>
                </ul>
                <div class="header-center-2-nav-yet hide">
                    <a class="header-center-2-nav-yet__btn"><span></span><span></span><span></span></a>
                    <div>
                        <ul></ul>
                    </div>
                </div>
            </nav>
		<?php } ?>
    </div>
    <div class="header-center-2__col header-center-2__col_logo"><?php theme_site_logo(); ?></div>
    <div class="header-center-2__col header-center-2__col_actions">
		<?php
		$sort_blocks = get_theme_mod( 'store_logo_center_icons_sortable', Helper::get_default_theme_data( 'store_logo_center_icons_sortable' ) );
		if ( ! $sort_blocks ) {
			return;
		}

		foreach ( $sort_blocks as $key ) {
			switch ( $key ) {
				case 'currency_switcher':
					if ( Helper::is_plugin_active( 'woocommerce-currency-switcher/index.php' ) ) { ?>
                        <li class="navigation-store__woocs">
							<?php echo do_shortcode( '[woocs style="1" show_flags="0"]' ); ?>
                        </li>
						<?php
					}
					break;
				case 'search':
					?>
                    <div class="navigation__search" data-da=".header-center-2 .menu__content, 1024">
						<?php if ( get_theme_mod( 'header_search', true ) ) { ?>
                            <a class="btn-search" href="#">
                                <svg class="icon-search" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                                    <path d="M10 18a7.952 7.952 0 0 0 4.897-1.688l4.396 4.396l1.414-1.414l-4.396-4.396A7.952 7.952 0 0 0 18 10c0-4.411-3.589-8-8-8s-8 3.589-8 8s3.589 8 8 8zm0-14c3.309 0 6 2.691 6 6s-2.691 6-6 6s-6-2.691-6-6s2.691-6 6-6z" fill="#626262"></path>
                                </svg>
                                <span><?php _e( 'Поиск', 'wescle' ); ?></span>
                            </a>
							<?php get_template_part( 'template-parts/header/navigation', 'search-form' ); ?>
						<?php } ?>
                    </div>
					<?php
					break;
				case 'compare':
					if ( Helper::is_active_compare() ) {
						echo '<div class="_compare">';
						wescle_compare_link( 'store-center' );
						echo '</div>';
					}
					break;
				case 'wishlist':
					wescle_wishlist_link( 'store-center' );
					break;
				case 'cart':
					?>
                    <div class="navigation-store__cart"><?php
						$header_store_cart_big = get_theme_mod( 'header_store_cart_big' );
						wescle_cart_link( 'store-center' );
						if ( ! $header_store_cart_big ) {
							the_widget( 'WC_Widget_Cart', 'title=' );
						} ?></div>
					<?php
					break;
				case 'lang_switcher':
					$html_langs = header_store_center_languages();
					if ( $html_langs ) {
						echo '<div class="_langs _dropdown" data-da=".header-center-2 .menu__content, 1024">' . $html_langs . '</div>';
					}
					break;
				case 'account':
					if ( is_user_logged_in() ) { ?>
                        <a class="_account-logged" href="<?php echo wc_get_account_endpoint_url( 'dashboard' ); ?>">
                            <svg xmlns="http://www.w3.org/2000/svg" aria-hidden="true" role="img" width="0.88em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 448 512">
                                <path fill="currentColor"
                                      d="M313.6 304c-28.7 0-42.5 16-89.6 16c-47.1 0-60.8-16-89.6-16C60.2 304 0 364.2 0 438.4V464c0 26.5 21.5 48 48 48h352c26.5 0 48-21.5 48-48v-25.6c0-74.2-60.2-134.4-134.4-134.4zM400 464H48v-25.6c0-47.6 38.8-86.4 86.4-86.4c14.6 0 38.3 16 89.6 16c51.7 0 74.9-16 89.6-16c47.6 0 86.4 38.8 86.4 86.4V464zM224 288c79.5 0 144-64.5 144-144S303.5 0 224 0S80 64.5 80 144s64.5 144 144 144zm0-240c52.9 0 96 43.1 96 96s-43.1 96-96 96s-96-43.1-96-96s43.1-96 96-96z"></path>
                            </svg>
                        </a>
					<?php } else { ?>
                        <div class="_account-unlogged" data-da=".header-center-2 .menu__content, 1024">
                            <a class="btn btn-main btn-main" href="<?php echo wc_get_account_endpoint_url( 'dashboard' ); ?>"><?php _e( 'Войти', 'wescle' ); ?></a>
                            <a class="btn btn-main btn-main_blue" href="<?php echo wc_get_account_endpoint_url( 'dashboard' ); ?>"><?php _e( 'Регистрация', 'wescle' ); ?></a>
                        </div>
					<?php }
					break;
			}
		}
		?>
    </div>
</div>