<?php
$button_text = get_theme_mod( 'button_title', esc_html__( 'Заказать звонок', 'wescle' ) );
if ( ! $button_text ) {
	return;
}

$button_is_default = get_theme_mod( 'button_is_default', false );
$button_page_id    = get_theme_mod( 'button_page_link', 0 );
$button_link       = get_theme_mod( 'button_custom_link', '' );

$target = '_self';
if ( $button_link && ! $button_page_id && strpos( $button_link, '#' ) === false ) {
	$target = '_blank';
}

if ( $button_is_default && $button_page_id ) {
	$button_link = get_permalink( $button_page_id );
}
$btn_flare = '';
if ( get_theme_mod( 'header_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}

if ( $button_is_default ) {
	printf( '<a class="header-top__btn btn btn-main ' . $btn_flare . '" href="%1$s" target="%2$s">%3$s</a>', $button_link, $target, esc_html( $button_text ) );
}
else {
	printf( '<a class="header-top__btn btn btn-main ' . $btn_flare . '_popup-link" href="#modal-call">%1$s</a>', esc_html( $button_text ) );
}
