<?php
if ( Helper::is_plugin_active( 'buddypress/bp-loader.php' ) ) { ?>
    <div class="header-top__account">
		<?php if ( is_user_logged_in() ) {
			$user = wp_get_current_user();
			?>
            <a class="account" href="<?php echo bp_loggedin_user_domain(); ?>">
				<?php echo get_avatar( $user->user_email, 44 ); ?>
            </a>
		<?php } else { ?>
            <span class="account">
                <picture>
                    <source type="image/webp" srcset="<?php echo get_template_directory_uri(); ?>/assets/img/user.webp"/>
                    <img src="./img/user.png" srcset="<?php echo get_template_directory_uri(); ?>/assets/img/user.png" alt="photo" loading="lazy" width="100" height="100"/>
                </picture>
            </span>
            <div class="account-options">
                <a href="<?php echo wp_login_url( bp_get_requested_url() ); ?>">Войти</a>
                <a href="<?php echo bp_get_signup_page(); ?>">Регистрация</a>
            </div>
		<?php } ?>
    </div>
<?php } ?>