<?php
$is_top_tabs   = $args['top_tabs'] ?? false;
$text          = get_theme_mod( 'address_text', Helper::get_default_theme_data( 'address_text' ) );
$link          = get_theme_mod( 'address_link', Helper::get_default_theme_data( 'address_link' ) );
$img_id        = get_theme_mod( 'address_image' );
$address_items = get_theme_mod( 'address_others', [] );

if ( ! $text ) {
	return;
}

if ( $link ) {
	$open_tag  = '<a class="location__link" href="' . esc_url( $link ) . '" target="_blank" rel="noopener">';
	$close_tag = '</a>';
}
else {
	$open_tag  = '<div class="location__link">';
	$close_tag = '</div>';
}
$div_class = 'header-top__location location';
if ( ! $address_items ) {
	$div_class .= ' _one-location';
}
?>
<div class="<?php echo $div_class; ?>">
    <button class="location__btn btn-location">
        <svg class="icon-location" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
            <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5a2.5 2.5 0 0 1 0-5a2.5 2.5 0 0 1 0 5z" fill="#2178ff"></path>
        </svg>
    </button>
	<?php echo $open_tag; ?>
	<?php if ( $img_id ) { ?>
		<?php echo wp_get_attachment_image( $img_id, 'medium', false, [ 'class' => 'icon-location icon-custom' ] ); ?>
	<?php } else { ?>
        <svg class="icon-location" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
            <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5a2.5 2.5 0 0 1 0-5a2.5 2.5 0 0 1 0 5z" fill="#2178ff"></path>
        </svg>
	<?php } ?>
    <span><?php echo nl2br( $text ); ?></span>
	<?php echo $close_tag; ?>
    <button class="_arrowUpDown location__btn-arrow btn-arrow">
        <svg class="_arrow-up" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
            <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                <path d="M30 12L16 24L2 12"></path>
            </g>
        </svg>
        <svg class="_arrow-down" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
            <g fill="none" stroke="#626262" stroke-linecap="round" stroke-linejoin="round" stroke-width="4">
                <path d="M30 12L16 24L2 12"></path>
            </g>
        </svg>
    </button>
    <div class="location__dropdown dropdown-content">
		<?php
		foreach ( $address_items as $item ) {
			$text   = $item['text'];
			$link   = $item['url'];
			$img_id = $item['image'];
			if ( ! $text ) {
				continue;
			}

			if ( $link ) {
				$open_tag  = '<a class="location__link" href="' . esc_url( $link ) . '" target="_blank" rel="noopener">';
				$close_tag = '</a>';
			}
			else {
				$open_tag  = '<div class="location__link">';
				$close_tag = '</div>';
			}

			echo $open_tag;
			if ( $img_id ) { ?>
				<?php echo wp_get_attachment_image( $img_id, 'medium', false, [ 'class' => 'icon-location icon-custom' ] ); ?>
			<?php } else { ?>
                <svg class="icon-location" xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                    <path d="M12 2C8.13 2 5 5.13 5 9c0 5.25 7 13 7 13s7-7.75 7-13c0-3.87-3.13-7-7-7zm0 9.5a2.5 2.5 0 0 1 0-5a2.5 2.5 0 0 1 0 5z" fill="#2178ff"></path>
                </svg>
			<?php } ?>
            <span><?php echo nl2br( $text ); ?></span>
			<?php
			echo $close_tag;
		}
		?>
    </div>
</div>

