<?php
$widget_label    = get_theme_mod( 'module_mess_label', Helper::get_default_theme_data( 'module_mess_label' ) );
$social_items    = get_theme_mod( 'module_mess_social', [] );
$message_items   = get_theme_mod( 'module_mess_messages', [] );
$manager_icon    = get_theme_mod( 'module_mess_manager_icon' );
$manager_name    = get_theme_mod( 'module_mess_manager_name' );
$manager_subname = get_theme_mod( 'module_mess_manager_subname' );
$text            = get_theme_mod( 'module_mess_text' );

$speed = intval( get_theme_mod( 'module_mess_messages_speed', Helper::get_default_theme_data( 'module_mess_messages_speed' ) ) );
?>
<div class="mess-widget">
	<?php if ( $message_items ) { ?>
        <div class="mess-widget-chat" data-speed="<?php echo $speed; ?>">
            <button class="btn-close" type="button">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                    <path fill="#626262" d="M13.41 12l4.3-4.29a1 1 0 1 0-1.42-1.42L12 10.59l-4.29-4.3a1 1 0 0 0-1.42 1.42l4.3 4.29l-4.3 4.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0l4.29-4.3l4.29 4.3a1 1 0 0 0 1.42 0a1 1 0 0 0 0-1.42z"></path>
                </svg>
            </button>
            <div class="mess-widget-chat__slider">
				<?php foreach ( $message_items as $item ) { ?>
                    <div class="mess-widget-chat__slide">
                        <div class="mess-widget-chat__item">
							<?php if ( $item['image'] ) { ?>
                                <div class="mess-widget-chat__img">
									<?php echo wp_get_attachment_image( $item['image'], 'thumbnail' ); ?>
                                </div>
							<?php } ?>
                            <div class="mess-widget-chat__text"><?php echo nl2br( $item['text'] ); ?></div>
                        </div>
                    </div>
				<?php } ?>
            </div>
        </div>
	<?php } ?>
    <div class="mess-widget-block _hide">
        <button class="btn-close" type="button">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                <path fill="#626262" d="M13.41 12l4.3-4.29a1 1 0 1 0-1.42-1.42L12 10.59l-4.29-4.3a1 1 0 0 0-1.42 1.42l4.3 4.29l-4.3 4.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0l4.29-4.3l4.29 4.3a1 1 0 0 0 1.42 0a1 1 0 0 0 0-1.42z"></path>
            </svg>
        </button>
        <div class="mess-widget-block__header">
            <div class="mess-widget-block__author author-mess">
				<?php if ( $manager_icon ) { ?>
                    <div class="author-mess__img">
						<?php echo wp_get_attachment_image( $manager_icon, 'thumbnail' ); ?>
                        <span class="author-mess__availability"></span>
                    </div>
				<?php } ?>
                <div class="author-mess__desc">
					<?php if ( $manager_name ) { ?>
                        <div class="author-mess__name"><?php echo $manager_name; ?></div>
					<?php } ?>
					<?php if ( $manager_subname ) { ?>
                        <div class="author-mess__schedule"><?php echo $manager_subname; ?></div>
					<?php } ?>
                </div>
            </div>
        </div>
		<?php if ( $text ) { ?>
            <div class="mess-widget-block__info"><?php echo $text; ?></div>
		<?php } ?>
        <div class="mess-widget-block__list">
			<?php foreach ( $social_items as $item ) { ?>
				<?php
				$type = $item['mess_social_type'];
				if ( 'tel' === $type ) {
					$type = 'call';
				}

				$img_id = $item['mess_social_type_custom'] ?? 0;
				if ( $img_id ) {
					$type = 'custom';
				}

				$target_blank = '';
				if ( $item['mess_social_is_blank'] ) {
					$target_blank = 'target="_blank" rel="noopener noreferrer"';
				}
				$url = '#';
				if ( $item['mess_social_url'] ) {
					$url = $item['mess_social_url'];
				}

				$custom_class = '';
				if ( strpos( $url, '#wescle-modal' ) !== false || $url === '#modal-call' ) {
					$custom_class = '_popup-link';
					$target_blank = '';
				}
				?>
                <a class="mess-widget-block__item <?php echo $custom_class; ?>" href="<?php echo $url; ?>" <?php echo $target_blank; ?> data-mess="_<?php echo $type; ?>">
                    <span class="mess-widget-block__item-icon"><?php echo Helper::html_svg_icon( 'mess_' . $type, $img_id ); ?></span>
                    <div class="mess-widget-block__item-desc">
						<?php if ( $item['mess_social_title'] ) { ?>
                            <div class="mess-widget-block__item-name"><?php echo $item['mess_social_title']; ?></div>
						<?php } ?>
						<?php if ( $item['mess_social_text'] ) { ?>
                            <div class="mess-widget-block__item-info"><?php echo $item['mess_social_text']; ?></div>
						<?php } ?>
                    </div>
                </a>
			<?php } ?>
        </div>
    </div>
    <div class="mess-widget__btn">
        <div class="_static">
            <div>
				<?php
				if ( $img_id = get_theme_mod( 'module_mess_button_image' ) ) {
					echo wp_get_attachment_image( $img_id, 'thumbnail' );
				}
				else {
					?>
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                        <path d="M20 2H4c-1.103 0-2 .897-2 2v12c0 1.103.897 2 2 2h3v3.767L13.277 18H20c1.103 0 2-.897 2-2V4c0-1.103-.897-2-2-2zm0 14h-7.277L9 18.233V16H4V4h16v12z" fill="#626262"></path>
                        <path d="M7 7h10v2H7zm0 4h7v2H7z" fill="#626262"></path>
                    </svg>
				<?php } ?>
				<?php if ( $widget_label ) { ?>
                    <span><?php echo $widget_label; ?></span>
				<?php } ?>
            </div>
        </div>
        <div class="_dynamic _hide">
            <div class="mess-widget__icons"></div>
        </div>
    </div>
</div>