<?php
$ul_class      = $args['ul_class'] ?? 'footer__socials';
$link_vk       = get_theme_mod( 'social_vk', '#' );
$link_ok       = get_theme_mod( 'social_ok', '#' );
$link_fb       = get_theme_mod( 'social_fb', '#' );
$link_tw       = get_theme_mod( 'social_tw', '#' );
$link_inst     = get_theme_mod( 'social_inst', '#' );
$link_telegram = get_theme_mod( 'social_telegram', '#' );
$link_linked   = get_theme_mod( 'social_linked', '#' );
$link_pi       = get_theme_mod( 'social_pi', '#' );
$link_yt       = get_theme_mod( 'social_yt', '#' );
$link_yd       = get_theme_mod( 'social_yd' );
$link_pm       = get_theme_mod( 'social_pulse_mail' );
$link_tinkoff  = get_theme_mod( 'social_tinkoff' );

$markup      = wescle_markup_external_link( 'socials__link' );
$addit_class = get_theme_mod( 'footer_block_classes_socials' );

$social_custom_items = get_theme_mod( 'social_custom_items', [] );
?>
<ul class="<?php echo $ul_class; ?> socials <?php echo $addit_class; ?>">
	<?php if ( $link_vk ) { ?>
        <li class="socials__item socials__item-vk">
			<?php echo str_replace( '%url%', $link_vk, $markup['tag_open'] ); ?>
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                <path d="M10 .4C4.698.4.4 4.698.4 10s4.298 9.6 9.6 9.6s9.6-4.298 9.6-9.6S15.302.4 10 .4zm3.692 10.831s.849.838 1.058 1.227c.006.008.009.016.011.02c.085.143.105.254.063.337c-.07.138-.31.206-.392.212h-1.5c-.104 0-.322-.027-.586-.209c-.203-.142-.403-.375-.598-.602c-.291-.338-.543-.63-.797-.63a.305.305 0 0 0-.095.015c-.192.062-.438.336-.438 1.066c0 .228-.18.359-.307.359h-.687c-.234 0-1.453-.082-2.533-1.221c-1.322-1.395-2.512-4.193-2.522-4.219c-.075-.181.08-.278.249-.278h1.515c.202 0 .268.123.314.232c.054.127.252.632.577 1.2c.527.926.85 1.302 1.109 1.302a.3.3 0 0 0 .139-.036c.338-.188.275-1.393.26-1.643c0-.047-.001-.539-.174-.775c-.124-.171-.335-.236-.463-.26a.55.55 0 0 1 .199-.169c.232-.116.65-.133 1.065-.133h.231c.45.006.566.035.729.076c.33.079.337.292.308 1.021c-.009.207-.018.441-.018.717c0 .06-.003.124-.003.192c-.01.371-.022.792.24.965a.216.216 0 0 0 .114.033c.091 0 .365 0 1.107-1.273a9.718 9.718 0 0 0 .595-1.274c.015-.026.059-.106.111-.137a.266.266 0 0 1 .124-.029h1.781c.194 0 .327.029.352.104c.044.119-.008.482-.821 1.583l-.363.479c-.737.966-.737 1.015.046 1.748z"
                      fill="#626262"></path>
            </svg>
			<?php echo $markup['tag_close']; ?>
        </li>
	<?php } ?>
	<?php if ( $link_ok ) { ?>
        <li class="socials__item socials__item-ok">
			<?php echo str_replace( '%url%', $link_ok, $markup['tag_open'] ); ?>
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512.5 512.5">
                <path d="M256.2 277.3c76.6 0 138.7-62.1 138.7-138.7S332.8 0 256.2 0 117.6 62.1 117.6 138.7C117.7 215.2 179.7 277.2 256.2 277.3zM256.2 64c41.2 0 74.7 33.4 74.7 74.7s-33.4 74.7-74.7 74.7 -74.7-33.4-74.7-74.7S215 64 256.2 64z"
                      fill="#626262"/>
                <path d="M392.1 343c15.1-9.9 24.2-26.8 24.2-44.8 0.2-15-8.2-28.7-21.7-35.3 -13.8-6.9-30.4-5.3-42.7 4 -57 41.5-134.3 41.5-191.3 0 -12.3-9.3-28.8-10.9-42.7-4 -13.4 6.6-21.9 20.3-21.7 35.3 0 18 9.1 34.9 24.2 44.8 19.3 12.9 40.4 22.9 62.5 29.9 3.8 1.2 7.6 2.2 11.6 3.2l-64.5 63c-16.9 16.4-17.3 43.4-0.9 60.3 16.4 16.9 43.4 17.3 60.3 0.9 0.4-0.3 0.7-0.7 1-1l65.7-68 65.8 68.1c16.4 16.9 43.4 17.4 60.3 1 16.9-16.4 17.4-43.4 1-60.3 -0.3-0.4-0.7-0.7-1-1l-64.4-63c4-1 7.9-2.1 11.7-3.3C351.7 365.9 372.8 355.9 392.1 343z"
                      fill="#626262"/>
            </svg>
			<?php echo $markup['tag_close']; ?>
        </li>
	<?php } ?>
	<?php if ( $link_fb ) { ?>
        <li class="socials__item socials__item-fb">
			<?php echo str_replace( '%url%', $link_fb, $markup['tag_open'] ); ?>
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                <path d="M10 .4C4.698.4.4 4.698.4 10s4.298 9.6 9.6 9.6s9.6-4.298 9.6-9.6S15.302.4 10 .4zm2.274 6.634h-1.443c-.171 0-.361.225-.361.524V8.6h1.805l-.273 1.486H10.47v4.461H8.767v-4.461H7.222V8.6h1.545v-.874c0-1.254.87-2.273 2.064-2.273h1.443v1.581z" fill="#626262"></path>
            </svg>
			<?php echo $markup['tag_close']; ?>
        </li>
	<?php } ?>
	<?php if ( $link_tw ) { ?>
        <li class="socials__item socials__item-tw">
			<?php echo str_replace( '%url%', $link_tw, $markup['tag_open'] ); ?>
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                <path d="M10 .4C4.698.4.4 4.698.4 10s4.298 9.6 9.6 9.6s9.6-4.298 9.6-9.6S15.302.4 10 .4zm3.905 7.864c.004.082.005.164.005.244c0 2.5-1.901 5.381-5.379 5.381a5.335 5.335 0 0 1-2.898-.85c.147.018.298.025.451.025c.886 0 1.701-.301 2.348-.809a1.895 1.895 0 0 1-1.766-1.312a1.9 1.9 0 0 0 .853-.033a1.892 1.892 0 0 1-1.517-1.854v-.023c.255.141.547.227.857.237a1.89 1.89 0 0 1-.585-2.526a5.376 5.376 0 0 0 3.897 1.977a1.891 1.891 0 0 1 3.222-1.725a3.797 3.797 0 0 0 1.2-.459a1.9 1.9 0 0 1-.831 1.047a3.799 3.799 0 0 0 1.086-.299a3.834 3.834 0 0 1-.943.979z"
                      fill="#626262"></path>
            </svg>
			<?php echo $markup['tag_close']; ?>
        </li>
	<?php } ?>
	<?php if ( $link_inst ) { ?>
        <li class="socials__item socials__item-inst">
			<?php echo str_replace( '%url%', $link_inst, $markup['tag_open'] ); ?>
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 1024 1024">
                <path d="M512 1024q-104 0-199-40.5t-163.5-109T40.5 711T0 512t40.5-199t109-163.5T313 40.5T512 0t199 40.5t163.5 109t109 163.5t40.5 199t-40.5 199t-109 163.5t-163.5 109t-199 40.5zm256-704q0-26-18.5-45T704 256H320q-26 0-45 19t-19 45v64h114q58-64 142-64t142 64h114v-64zM384 512q0 53 37.5 90.5T512 640t90.5-37.5T640 512t-37.5-90.5T512 384t-90.5 37.5T384 512zm384-64h-76q12 33 12 64q0 80-56 136t-136 56t-136-56t-56-136q0-31 12-64h-76v256q0 27 18.5 45.5T320 768h384q27 0 45.5-18.5T768 704V448z"
                      fill="#626262"></path>
            </svg>
			<?php echo $markup['tag_close']; ?>
        </li>
	<?php } ?>
	<?php if ( $link_telegram ) { ?>
        <li class="socials__item socials__item-telegram">
			<?php echo str_replace( '%url%', $link_telegram, $markup['tag_open'] ); ?>
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 32 32">
                <path d="M16 .5C7.437.5.5 7.438.5 16S7.438 31.5 16 31.5c8.563 0 15.5-6.938 15.5-15.5S24.562.5 16 .5zm7.613 10.619l-2.544 11.988c-.188.85-.694 1.056-1.4.656l-3.875-2.856l-1.869 1.8c-.206.206-.381.381-.781.381l.275-3.944l7.181-6.488c.313-.275-.069-.431-.482-.156l-8.875 5.587l-3.825-1.194c-.831-.262-.85-.831.175-1.231l14.944-5.763c.694-.25 1.3.169 1.075 1.219z" fill="#626262"></path>
            </svg>
			<?php echo $markup['tag_close']; ?>
        </li>
	<?php } ?>
	<?php if ( $link_pi ) { ?>
        <li class="socials__item socials__item-pi">
			<?php echo str_replace( '%url%', $link_pi, $markup['tag_open'] ); ?>
            <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 512.9 512.9">
                <path d="M256.4 0c-141.2 0-256 114.8-256 256 0 105 62.7 195.1 153.6 234.8 -0.9-17.7 0-39.7 4.4-59.1 5.3-21.2 32.7-139.5 32.7-139.5s-7.9-16.8-7.9-40.6c0-38 22.1-66.2 49.4-66.2 23 0 34.4 17.7 34.4 38.8 0 23-15 58.3-23 90.9 -6.2 27.4 13.2 49.4 40.6 49.4 48.6 0 81.2-62.7 81.2-135.9 0-56.5-38-98-106.8-98 -77.7 0-126.2 58.3-126.2 122.7 0 22.1 6.2 38 16.8 50.3 4.4 5.3 5.3 7.9 3.5 14.1 -0.9 4.4-4.4 15.9-5.3 20.3 -1.8 6.2-7.1 8.8-13.2 6.2 -36.2-15-52.1-53.8-52.1-98 0-72.4 60.9-159.8 182.7-159.8 98 0 162.4 70.6 162.4 146.5 0 100.6-55.6 175.7-137.7 175.7 -27.4 0-53.8-15-62.7-31.8 0 0-15 59.1-17.7 70.6 -5.3 19.4-15.9 39.7-25.6 54.7 23 7.1 47.7 10.6 72.4 10.6 141.2 0 256-114.8 256-256S397.7 0 256.4 0"
                      fill="#626262"/>
            </svg>
			<?php echo $markup['tag_close']; ?>
        </li>
	<?php } ?>
	<?php if ( $link_linked ) { ?>
        <li class="socials__item socials__item-linked">
			<?php echo str_replace( '%url%', $link_linked, $markup['tag_open'] ); ?>
            <svg enable-background="new 0 0 24 24" height="512" viewBox="0 0 24 24" width="512" xmlns="http://www.w3.org/2000/svg">
                <g fill="#626262">
                    <path d="m23.994 24v-.001h.006v-8.802c0-4.306-.927-7.623-5.961-7.623-2.42 0-4.044 1.328-4.707 2.587h-.07v-2.185h-4.773v16.023h4.97v-7.934c0-2.089.396-4.109 2.983-4.109 2.549 0 2.587 2.384 2.587 4.243v7.801z"/>
                    <path d="m.396 7.977h4.976v16.023h-4.976z"/>
                    <path d="m2.882 0c-1.591 0-2.882 1.291-2.882 2.882s1.291 2.909 2.882 2.909 2.882-1.318 2.882-2.909c-.001-1.591-1.292-2.882-2.882-2.882z"/>
                </g>
            </svg>
			<?php echo $markup['tag_close']; ?>
        </li>
	<?php } ?>
	<?php if ( $link_yt ) { ?>
        <li class="socials__item socials__item-yt">
			<?php echo str_replace( '%url%', $link_yt, $markup['tag_open'] ); ?>
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                <path d="M11.603 9.833L9.357 8.785C9.161 8.694 9 8.796 9 9.013v1.974c0 .217.161.319.357.228l2.245-1.048c.197-.092.197-.242.001-.334zM10 .4C4.698.4.4 4.698.4 10s4.298 9.6 9.6 9.6s9.6-4.298 9.6-9.6S15.302.4 10 .4zm0 13.5c-4.914 0-5-.443-5-3.9s.086-3.9 5-3.9s5 .443 5 3.9s-.086 3.9-5 3.9z" fill="#626262"></path>
            </svg>
			<?php echo $markup['tag_close']; ?>
        </li>
	<?php } ?>
	<?php if ( $link_yd ) { ?>
        <li class="socials__item socials__item-yd">
			<?php echo str_replace( '%url%', $link_yd, $markup['tag_open'] ); ?>
            <svg width="58" height="58" viewBox="0 0 58 58" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd"
                      d="M26.3457 12.7516L39.1604 17.6127L39.1479 24.313L38.2522 25.232C37.8432 25.5977 37.8311 25.5987 37.4669 25.8841L29.3192 32.6955C28.7442 33.1693 26.5534 34.6272 26.5062 35.3614L39.128 40.2797L39.1207 46.5188C38.9767 47.3358 39.1032 46.7671 38.9447 47.0208C38.4594 47.9079 38.4879 47.5606 37.2666 48.6053C35.7871 49.871 26.7073 56.9708 26.2296 57.9142C35.2081 57.9142 39.8101 57.0176 46.7814 51.8488C61.6277 40.841 61.2552 17.3442 47.4397 6.6137C44.1827 4.0841 42.4202 3.101 38.7464 1.6891C37.4586 3.383 28.5998 10.2849 26.3457 12.7516ZM18.5495 55.9838C20.0256 56.9288 24.6456 57.8741 26.2296 57.9142C26.7073 56.9708 35.7871 49.871 37.2666 48.6053C38.4879 47.5606 38.4594 47.9079 38.9447 47.0208L31.8151 44.2185C29.5824 46.504 27.396 48.0375 25.0928 50.1867C24.0262 51.1819 22.7327 52.1096 21.7245 53.0957C20.8147 53.9856 19.2581 55.0225 18.5495 55.9838ZM18.5495 55.9838C19.2581 55.0225 20.8147 53.9856 21.7245 53.0957C22.7327 52.1096 24.0262 51.1819 25.0928 50.1867C27.396 48.0375 29.5824 46.504 31.8151 44.2185C29.4296 43.5686 24.5067 41.4157 21.6655 40.3503C17.9502 38.9573 18.7518 40.4521 18.7269 32.5082L28.6395 24.2967C29.1551 23.8655 29.6821 23.403 30.2291 22.9895C31.6232 21.9352 31.4077 22.1736 31.6034 21.4272L18.8079 16.5213C18.8566 15.4365 18.6922 10.3924 18.8688 9.8741C19.0776 9.2613 21.9352 7.2044 22.7304 6.5635C24.0539 5.4966 30.1083 0.8577 30.6463 0C22.2812 0 16.873 1.582 10.716 6.3724C4.2286 11.4196 0.5366 19.0143 0 26.9128V30.9562C0.6011 39.6765 5.0891 48.3037 13.9457 53.8622C14.8088 54.4038 17.5244 55.8935 18.5495 55.9838ZM18.8079 16.5213L18.7371 9.7838L26.3457 12.7516C28.5998 10.2849 37.4586 3.383 38.7464 1.6891C36.427 1.0077 33.619 0 30.6463 0C30.1083 0.8577 24.0539 5.4966 22.7304 6.5635C21.9352 7.2044 19.0776 9.2613 18.8688 9.8741C18.6922 10.3924 18.8566 15.4365 18.8079 16.5213Z"
                      fill="#9B0F0F"/>
            </svg>
			<?php echo $markup['tag_close']; ?>
        </li>
	<?php } ?>
	<?php if ( $link_pm ) { ?>
        <li class="socials__item socials__item-pm">
			<?php echo str_replace( '%url%', $link_pm, $markup['tag_open'] ); ?>
            <svg width="490" height="489" viewBox="0 0 490 489" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path d="M274.4 196.399C274.4 213.079 260.831 226.647 244.152 226.647C227.473 226.647 213.905 213.079 213.905 196.399C213.905 179.721 227.473 166.152 244.152 166.152C260.83 166.152 274.4 179.721 274.4 196.399ZM244.152 95.842C188.705 95.842 143.595 140.951 143.595 196.399C143.595 251.847 188.705 296.957 244.152 296.957C264.467 296.957 284.053 290.908 300.795 279.468L301.086 279.268L287.538 263.519L287.308 263.667C274.418 271.959 259.496 276.342 244.152 276.342C200.072 276.342 164.212 240.479 164.212 196.399C164.212 152.319 200.073 116.459 244.152 116.459C288.231 116.459 324.095 152.319 324.095 196.399C324.095 202.111 323.459 207.895 322.211 213.584C319.682 223.958 312.42 227.136 306.964 226.716C301.479 226.274 295.06 222.362 295.018 212.796V196.4C295.018 168.354 272.2 145.537 244.153 145.537C216.107 145.537 193.289 168.353 193.289 196.4C193.289 224.447 216.107 247.265 244.153 247.265C257.777 247.265 270.557 241.937 280.191 232.25C285.791 240.967 294.924 246.433 305.313 247.267C306.205 247.338 307.114 247.375 308.017 247.375C315.331 247.375 322.58 244.931 328.428 240.492C334.456 235.916 338.955 229.296 341.44 221.347C341.842 220.063 342.568 217.121 342.572 217.102L342.593 216.996C344.057 210.613 344.711 204.255 344.711 196.4C344.71 140.952 299.6 95.842 244.152 95.842Z"
                      fill="black"/>
                <path d="M245 0.5C110.104 0.5 0.75 109.854 0.75 244.75C0.75 379.646 110.104 489 245 489C379.896 489 489.25 379.646 489.25 244.75C489.25 109.854 379.896 0.5 245 0.5ZM245 30.498C363.327 30.498 459.252 126.422 459.252 244.75C459.252 276.061 452.532 305.801 440.461 332.612H425.681C421.368 332.612 417.49 335.313 415.919 339.323L409.341 356.053L388.819 236.281C387.948 231.275 383.59 227.735 378.493 227.735H378.449C373.395 227.735 369.039 231.226 368.123 236.193L348.907 342.916L340.454 302.161C339.584 297.886 336.184 294.617 331.916 293.925C327.602 293.19 323.375 295.233 321.153 298.936L301.24 332.677H256.492C256.343 332.677 256.195 332.682 256.048 332.688C255.64 332.64 255.225 332.612 254.803 332.612H161.69C157.377 332.612 153.499 335.313 151.93 339.323L145.35 356.053L124.829 236.281C123.957 231.275 119.6 227.735 114.502 227.735H114.459C109.405 227.735 105.047 231.226 104.132 236.193L84.916 342.917L76.463 302.162C75.592 297.887 72.192 294.618 67.923 293.926C63.61 293.191 59.382 295.234 57.161 298.937L44.5 320.392C35.621 296.87 30.749 271.38 30.749 244.75C30.748 126.422 126.672 30.498 245 30.498ZM68.526 366.253C63.532 359.013 58.971 351.453 54.882 343.606L61.431 332.308L68.526 366.253ZM95.996 398.685L114.241 298.545L130.973 396.401C131.756 401.063 135.547 404.591 140.209 405.072C144.958 405.508 149.359 402.915 151.059 398.493L168.836 353.636H254.803C255.088 353.636 255.369 353.621 255.648 353.599C255.928 353.621 256.208 353.636 256.493 353.636H307.211C310.915 353.636 314.357 351.349 316.232 348.168L325.424 332.308L339.367 399.017C340.369 403.895 344.639 406.075 349.649 406.075H349.78C354.791 406.075 359.061 403.679 359.975 398.756L378.232 298.546L394.964 396.402C395.027 396.777 395.116 397.142 395.217 397.502C356.55 435.532 303.52 459.003 245.001 459.003C187.09 459.002 134.556 436.018 95.996 398.685Z"
                      fill="black"/>
            </svg>
			<?php echo $markup['tag_close']; ?>
        </li>
	<?php } ?>
	<?php if ( $link_tinkoff ) { ?>
        <li class="socials__item socials__item-tinkoff">
			<?php echo str_replace( '%url%', $link_tinkoff, $markup['tag_open'] ); ?>
            <svg width="90" height="90" viewBox="0 0 90 90" fill="none" xmlns="http://www.w3.org/2000/svg">
                <path fill-rule="evenodd" clip-rule="evenodd" d="M20 5C11.7157 5 5 11.7157 5 20V70C5 78.2843 11.7157 85 20 85H70C78.2843 85 85 78.2843 85 70V20C85 11.7157 78.2843 5 70 5H20ZM0 20C0 8.95431 8.95431 0 20 0H70C81.0457 0 90 8.95431 90 20V70C90 81.0457 81.0457 90 70 90H20C8.95431 90 0 81.0457 0 70V20Z" fill="black"/>
                <path fill-rule="evenodd" clip-rule="evenodd" d="M61.875 45L50.625 56.25V45H39.375V56.25L28.125 45H14.062L29.118 59.063L11.25 73.124H28.125L39.375 61.874V73.124H50.625V61.874L61.875 73.124H78.75L60.883 59.062L75.936 45H61.876H61.875ZM22.5 16.875V23H39.375V39.375H50.625V23H67.5V16.875H22.5Z" fill="black"/>
            </svg>
			<?php echo $markup['tag_close']; ?>
        </li>
	<?php } ?>

	<?php
	if ( $social_custom_items ) {
		foreach ( $social_custom_items as $key => $item ) {
			if ( ! $item['url'] ) {
				continue;
			}

			$image = $item['image'] ? wp_get_attachment_image( $item['image'], 'thumbnail' ) : $item['text'];
			?>
            <li class="socials__item socials__item-<?php echo $key; ?>">
				<?php echo str_replace( '%url%', $item['url'], $markup['tag_open'] ); ?>
				<?php echo $image; ?>
				<?php echo $markup['tag_close']; ?>
            </li>
			<?php

		}
	}
	?>

	<?php do_action( 'wescle_footer_socials' ); ?>
</ul>