<?php
$items = Helper::get_items_hidden_element();
foreach ( $items as $item ) {
	$item['href'] = $item['button_link'];
	if ( ! $item['href'] ) {
		$item['href'] = '#';
	}

	$item['opacity'] = intval( $item['opacity'] );

	if ( $item['opacity'] > 100 ) {
		$item['opacity'] = 100;
	}

	$opacity = 1 - floatval( $item['opacity'] / 100 );
	$style   = [
		'opacity:' . $opacity,
		'width:' . $item['width'] . 'px',
		'height:' . $item['height'] . 'px',
	];
	if ( $item['block_selector'] ) {
		$atts_data = [
			'data-position-selector' => $item['block_selector'],
			'data-position-left'     => $item['selector_position_left'],
			'data-position-top'      => $item['selector_position_top'],
		];
	}
	else {
		$atts_data = [
			'data-position-left' => $item['position_left'] . '%',
			'data-position-top'  => $item['position_top'] . '%',
		];
	}
	$atts_data['href'] = $item['href'];
	if ( $item['target_blank'] ) {
		$atts_data['target'] = '_blank';
		$atts_data['rel']    = 'noopener noreferrer';
	}

	$attributes = '';
	foreach ( $atts_data as $attr => $value ) {
		$value      = ( 'href' === $attr ) ? esc_url( $value ) : esc_attr( $value );
		$attributes .= ' ' . $attr . '="' . trim( $value ) . '"';
	}

	$class_popup = '';
	if ( strpos( $item['href'], '#wescle-modal' ) !== false || strpos( $item['href'], '#modal' ) !== false ) {
		$class_popup = '_popup-link';
	}
	?>
    <a class="find-hidden-element <?php echo $class_popup; ?> _hide" <?php echo $attributes; ?> data-style="<?php echo implode( ';', $style ); ?>">
		<?php echo wp_get_attachment_image( $item['image'], 'medium' ); ?>
    </a>
	<?php
}
