<?php
if ( ! get_theme_mod( 'module_banner_shares_enabled' ) ) {
	return;
}

$data = Helper::get_data_banner_shares();
if ( ! $data ) {
	return;
}

$title       = $data['title'];
$text        = $data['text'];
$button      = [];
$button_text = $data['btn_text'];
$button_url  = $data['btn_url'];
if ( $button_text && $button_url ) {
	$button = [
		'text' => $button_text,
		'url'  => $button_url,
	];
}

$timeout = intval( get_theme_mod( 'module_banner_shares_timeout', 0 ) );
if ( ! $timeout ) {
	$timeout = 0.1;
}
$timeout = $timeout * 1000;
$speed   = intval( get_theme_mod( 'module_banner_shares_speed', 2 ) );
$speed   = $speed * 1000;

$home_special_action_date  = $data['date'];
$home_special_action_hours = $data['hours'];
if ( $data['type'] == 'date' ) {
	$timer_data_attr = 'data-timer-stop="' . $home_special_action_date . 'T23:59:59"';
}
else {
	$timer_data_attr = 'data-timer-by="' . $home_special_action_hours . '"';
}

$style_arr = [];
$style_bg  = [];
if ( $bg_color = get_theme_mod( 'banner_shares_color_bg1' ) ) {
	$style_bg[] = $bg_color;
}
if ( $bg_color = get_theme_mod( 'banner_shares_color_bg2' ) ) {
	$style_bg[] = $bg_color;
}
if ( $bg_color = get_theme_mod( 'banner_shares_color_bg3' ) ) {
	$style_bg[] = $bg_color;
}
if ( $bg_color = get_theme_mod( 'banner_shares_color_bg4' ) ) {
	$style_bg[] = $bg_color;
}

if ( $style_bg ) {
	if ( count( $style_bg ) == 1 ) {
		$style_arr[] = 'background:' . current( $style_bg );
	}
	else {
		$style_arr[] = 'background:linear-gradient(270deg,' . implode( ',', $style_bg ) . ')';
	}
}
if ( $color = get_theme_mod( 'banner_shares_color_text' ) ) {
	$style_arr[] = 'color:' . $color;
}
$style = '';
if ( $style_arr ) {
	$style = 'style="' . implode( ';', $style_arr ) . '"';
}

$icon_color = get_theme_mod( 'banner_shares_color_icon' );
if ( ! $icon_color ) {
	$icon_color = '#ffffff';
}

$text_align = get_theme_mod( 'banner_shares_text_align', 'center' );
if ( $text_align != 'center' ) {
	$text_align = 'style="text-align:' . $text_align . '"';
}
?>
<div class="banner-shares _hide" id="banner-shares-<?php echo $data['key']; ?>" data-open-after="<?php echo $timeout; ?>" data-autoplay-speed="2000" <?php echo $style; ?>>
    <div class="container">
        <div class="banner-shares__slider">
            <div class="banner-shares__slide">
                <div class="banner-shares__item">
                    <div class="banner-shares__text"><?php echo $title; ?></div>
                    <div class="banner-shares__timer">
                        <div class="small-timer-block" id="banner-shares" <?php echo $timer_data_attr; ?>>
                            <div class="small-timer-block__time">
                                <div class="small-timer-block__item"><span class="days" data-days="">00</span><span class="small-timer-block__name"><?php _e( 'дней', 'wescle' ); ?></span></div>
                                <div class="small-timer-block__separator"></div>
                                <div class="small-timer-block__item"><span class="hours" data-hours="">00</span><span class="small-timer-block__name"><?php _e( 'часов', 'wescle' ); ?></span></div>
                                <div class="small-timer-block__separator"></div>
                                <div class="small-timer-block__item"><span class="minutes" data-minutes="">00</span><span class="small-timer-block__name"><?php _e( 'минут', 'wescle' ); ?></span></div>
                                <div class="small-timer-block__separator"></div>
                                <div class="small-timer-block__item"><span class="seconds" data-seconds="">00</span><span class="small-timer-block__name"><?php _e( 'секунд', 'wescle' ); ?></span></div>
                            </div>
                        </div>
                    </div>
					<?php if ( $button ) { ?>
						<?php
						$class_popup = '';
						if ( strpos( $button['url'], '#wescle-modal' ) !== false || strpos( $button['url'], '#modal' ) !== false ) {
							$class_popup = ' _popup-link';
						}
						?>
                        <div class="banner-shares__button"><a class="btn btn-main<?php echo $class_popup; ?>" href="<?php echo $button['url']; ?>"><span><?php echo $button['text']; ?></span></a></div>
					<?php } ?>
                </div>
            </div>
			<?php if ( $text ) { ?>
                <div class="banner-shares__slide banner-shares__slide-two">
                    <div class="banner-shares__item" <?php echo $text_align; ?>>
                        <div class="banner-shares__text"><?php echo nl2br( $text ); ?></div>
                    </div>
                </div>
			<?php } ?>
        </div>
    </div>
    <button class="btn-close" type="button">
        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
            <path fill="<?php echo $icon_color; ?>" d="M13.41 12l4.3-4.29a1 1 0 1 0-1.42-1.42L12 10.59l-4.29-4.3a1 1 0 0 0-1.42 1.42l4.3 4.29l-4.3 4.29a1 1 0 0 0 0 1.42a1 1 0 0 0 1.42 0l4.29-4.3l4.29 4.3a1 1 0 0 0 1.42 0a1 1 0 0 0 0-1.42z"></path>
        </svg>
    </button>
</div>