<?php
$youtube_link = get_post_meta( $post->ID, 'youtube_link', 1 );
$video_id     = Helper::get_youtube_video_id( $youtube_link );

$video_img_src = get_template_directory_uri() . '/assets/img/thumbnail-placeholder.jpg';
if ( $video_id ) {
	if ( $img_id = get_post_thumbnail_id() ) {
		$video_bg = wp_get_attachment_image_src( $img_id, 'medium_large' );
		if ( $video_bg ) {
			$video_img_src = $video_bg[0];
		}
	}
}
if ( ! $video_id ) {
	return;
}

$title = get_the_title();
$text  = $post->post_content;
?>
<div class="reviews-2-item">
    <div class="reviews-2-item__body">
        <div class="_video-iframe" data-src="<?php echo $video_id; ?>" style="background-image: url(<?php echo $video_img_src; ?>);">
            <div class="btn-play">
                <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 448 512">
                    <path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z" fill="white"></path>
                </svg>
            </div>
        </div>
        <div class="reviews-2-item__about">
			<?php if ( $title ) { ?>
                <div class="reviews-2-item__title"><?php echo $title; ?></div>
			<?php } ?>
			<?php if ( $text ) { ?>
                <div class="reviews-2-item__text"><?php echo $text; ?></div>
			<?php } ?>
        </div>
    </div>
    <div class="reviews-2-item__bottom">
		<?php if ( $title ) { ?>
            <div class="reviews-2-item__title"><?php echo $title; ?></div>
		<?php } ?>
		<?php if ( $text ) { ?>
            <div class="reviews-2-item__text"><?php echo $text; ?></div>
		<?php } ?>
    </div>
</div>