<?php
$img      = wp_get_attachment_image_src( get_post_thumbnail_id(), 'medium_large' );
$video_id = Helper::get_youtube_video_id( get_post_meta( $post->ID, 'youtube_link', 1 ) );
?>
<div class="video-section-block">
    <div class="video-section-block__video">
        <div class="_video-iframe" data-src="<?php echo $video_id; ?>" style="background-image: url('<?php echo $img[0]; ?>');">
			<?php if ( $video_id ) { ?>
                <div class="btn-play">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 448 512">
                        <path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z" fill="white"></path>
                    </svg>
                </div>
			<?php } ?>
        </div>
    </div>
    <div class="video-section-block__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
    <div class="video-section-block__description">
		<?php
		if ( $post->post_excerpt ) {
			echo $post->post_excerpt;
		}
		else {
			echo Helper::short_string( wp_strip_all_tags( $post->post_content ), 150 );
		}
		?>
    </div>
</div>