<?php
global $post;

$time_duration = get_post_meta( $post->ID, 'time_duration', 1 );
$custom_views  = get_post_meta( $post->ID, 'custom_views', 1 );
$hide_views    = get_post_meta( $post->ID, 'hide_views', 1 );
$custom_url    = get_post_meta( $post->ID, 'custom_url', 1 );
$play_tooltip  = get_post_meta( $post->ID, 'play_tooltip', 1 );
$info_tooltip  = get_post_meta( $post->ID, 'info_tooltip', 1 );

$play_link = $custom_url;
if ( ! $play_link ) {
	$play_link = get_permalink();
}

if ( ! $custom_views ) {
	$custom_views = get_post_views();
}
?>
<div class="videos-slider-item">
    <div class="videos-slider-item__top">
		<?php if ( $time_duration ) { ?>
            <div class="videos-slider-item__view-time"><?php echo $time_duration; ?></div>
		<?php } ?>
        <div class="videos-slider-item__image">
			<?php the_post_thumbnail( 'medium' ); ?>
        </div>
        <div class="videos-slider-item__actions">
            <div class="videos-slider-item__actions-col">
                <a class="videos-slider-item__actions-item" href="<?php echo $play_link; ?>">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 16 16">
                        <g fill="white">
                            <path d="M16 8A8 8 0 1 1 0 8a8 8 0 0 1 16 0zM6.79 5.093A.5.5 0 0 0 6 5.5v5a.5.5 0 0 0 .79.407l3.5-2.5a.5.5 0 0 0 0-.814l-3.5-2.5z"></path>
                        </g>
                    </svg>
					<?php if ( $play_tooltip ) { ?>
                        <span class="tooltip tooltip_top"><?php echo $play_tooltip; ?></span>
					<?php } ?>
                </a>
            </div>
			<?php if ( $info_tooltip ) { ?>
                <div class="videos-slider-item__actions-col">
                    <span class="videos-slider-item__actions-item">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 1024 1024">
                            <path d="M512 64C264.6 64 64 264.6 64 512s200.6 448 448 448s448-200.6 448-448S759.4 64 512 64zm32 664c0 4.4-3.6 8-8 8h-48c-4.4 0-8-3.6-8-8V456c0-4.4 3.6-8 8-8h48c4.4 0 8 3.6 8 8v272zm-32-344a48.01 48.01 0 0 1 0-96a48.01 48.01 0 0 1 0 96z" fill="white"></path>
                        </svg>
                        <span class="tooltip tooltip_top tooltip_top_right"><?php echo $info_tooltip; ?></span>
                    </span>
                </div>
			<?php } ?>
        </div>
    </div>
    <div class="videos-slider-item__body">
        <a class="videos-slider-item__title" href="<?php the_permalink(); ?>"><?php the_title(); ?></a>
		<?php if ( ! $hide_views && $custom_views ) { ?>
            <div class="videos-slider-item__views"><?php echo $custom_views; ?></div>
		<?php } ?>
    </div>
</div>
