<?php
$position  = get_post_meta( $post->ID, 'position', 1 );
$email     = get_post_meta( $post->ID, 'email', 1 );
$phone     = get_post_meta( $post->ID, 'phone', 1 );
$link_fb   = get_post_meta( $post->ID, 'link_fb', 1 );
$link_tw   = get_post_meta( $post->ID, 'link_twitter', 1 );
$link_inst = get_post_meta( $post->ID, 'link_inst', 1 );

$button_label = get_theme_mod( 'home_team_cpt_button_label', Helper::get_default_theme_data( 'home_team_cpt_button_label' ) );
?>
<div class="about-team-item">
    <div class="about-team-item__img">
		<?php echo wp_get_attachment_image( get_post_thumbnail_id(), 'medium' ); ?>
    </div>
    <div class="about-team-item__body">
        <div class="about-team-item__header">
			<?php if ( $position ) { ?>
                <div class="about-team-item__position"><?php echo $position; ?></div>
			<?php } ?>
            <div class="about-team-item__name"><?php echo get_the_title(); ?></div>
        </div>
        <div class="about-team-item__contacts">
			<?php if ( get_theme_mod( 'home_team_cpt_cf7', '' ) ) { ?>
                <div class="about-team-item__contacts-col">
                    <div class="about-team-item__contacts-item">
                        <a class="btn btn-main _popup-link" href="#modal-write-message"><?php echo $button_label; ?></a>
                    </div>
                </div>
			<?php } ?>
			<?php if ( $email ) { ?>
                <div class="about-team-item__contacts-col">
                    <div class="about-team-item__contacts-item about-team-item__contacts-item_inner">
                        <span><?php _e( 'E-mail', 'wescle' ); ?></span>
                        <a href="mailto:<?php echo $email; ?>"><?php echo $email; ?></a>
                    </div>
                </div>
			<?php } ?>
			<?php if ( $phone ) { ?>
                <div class="about-team-item__contacts-col">
                    <div class="about-team-item__contacts-item about-team-item__contacts-item_inner">
                        <span><?php _e( 'Телефон', 'wescle' ); ?></span>
                        <a href="tel:<?php echo Helper::phone_number_format( $phone ); ?>"><?php echo Helper::phone_number_mask( $phone ); ?></a>
                    </div>
                </div>
			<?php } ?>
        </div>
        <div class="about-team-item__socials">
			<?php if ( $link_fb ) { ?>
                <div class="about-team-item__socials-col">
                    <a class="about-team-item__socials-item" href="<?php echo $link_fb; ?>" target="_blank" rel="noopener noreferrer">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                            <g fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd" d="M0 12.067C0 18.033 4.333 22.994 10 24v-8.667H7V12h3V9.333c0-3 1.933-4.666 4.667-4.666c.866 0 1.8.133 2.666.266V8H15.8c-1.467 0-1.8.733-1.8 1.667V12h3.2l-.533 3.333H14V24c5.667-1.006 10-5.966 10-11.933C24 5.43 18.6 0 12 0S0 5.43 0 12.067z" fill="#626262"></path>
                            </g>
                        </svg>
                    </a>
                </div>
			<?php } ?>
			<?php if ( $link_tw ) { ?>
                <div class="about-team-item__socials-col"><a class="about-team-item__socials-item" href="<?php echo $link_tw; ?>" target="_blank" rel="noopener noreferrer">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
                            <path d="M10 .4C4.698.4.4 4.698.4 10s4.298 9.6 9.6 9.6s9.6-4.298 9.6-9.6S15.302.4 10 .4zm3.905 7.864c.004.082.005.164.005.244c0 2.5-1.901 5.381-5.379 5.381a5.335 5.335 0 0 1-2.898-.85c.147.018.298.025.451.025c.886 0 1.701-.301 2.348-.809a1.895 1.895 0 0 1-1.766-1.312a1.9 1.9 0 0 0 .853-.033a1.892 1.892 0 0 1-1.517-1.854v-.023c.255.141.547.227.857.237a1.89 1.89 0 0 1-.585-2.526a5.376 5.376 0 0 0 3.897 1.977a1.891 1.891 0 0 1 3.222-1.725a3.797 3.797 0 0 0 1.2-.459a1.9 1.9 0 0 1-.831 1.047a3.799 3.799 0 0 0 1.086-.299a3.834 3.834 0 0 1-.943.979z"
                                  fill="#626262"></path>
                        </svg>
                    </a>
                </div>
			<?php } ?>
			<?php if ( $link_inst ) { ?>
                <div class="about-team-item__socials-col"><a class="about-team-item__socials-item" href="<?php echo $link_inst; ?>" target="_blank" rel="noopener noreferrer">
                        <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 24 24">
                            <g fill="none">
                                <path fill-rule="evenodd" clip-rule="evenodd"
                                      d="M7.465 1.066C8.638 1.012 9.012 1 12 1c2.988 0 3.362.013 4.534.066c1.172.053 1.972.24 2.672.511c.733.277 1.398.71 1.948 1.27c.56.549.992 1.213 1.268 1.947c.272.7.458 1.5.512 2.67C22.988 8.639 23 9.013 23 12c0 2.988-.013 3.362-.066 4.535c-.053 1.17-.24 1.97-.512 2.67a5.396 5.396 0 0 1-1.268 1.949c-.55.56-1.215.992-1.948 1.268c-.7.272-1.5.458-2.67.512c-1.174.054-1.548.066-4.536.066c-2.988 0-3.362-.013-4.535-.066c-1.17-.053-1.97-.24-2.67-.512a5.397 5.397 0 0 1-1.949-1.268a5.392 5.392 0 0 1-1.269-1.948c-.271-.7-.457-1.5-.511-2.67C1.012 15.361 1 14.987 1 12c0-2.988.013-3.362.066-4.534c.053-1.172.24-1.972.511-2.672a5.396 5.396 0 0 1 1.27-1.948a5.392 5.392 0 0 1 1.947-1.269c.7-.271 1.5-.457 2.67-.511zm8.98 1.98c-1.16-.053-1.508-.064-4.445-.064c-2.937 0-3.285.011-4.445.064c-1.073.049-1.655.228-2.043.379c-.513.2-.88.437-1.265.822a3.412 3.412 0 0 0-.822 1.265c-.151.388-.33.97-.379 2.043c-.053 1.16-.064 1.508-.064 4.445c0 2.937.011 3.285.064 4.445c.049 1.073.228 1.655.379 2.043c.176.477.457.91.822 1.265c.355.365.788.646 1.265.822c.388.151.97.33 2.043.379c1.16.053 1.507.064 4.445.064c2.938 0 3.285-.011 4.445-.064c1.073-.049 1.655-.228 2.043-.379c.513-.2.88-.437 1.265-.822c.365-.355.646-.788.822-1.265c.151-.388.33-.97.379-2.043c.053-1.16.064-1.508.064-4.445c0-2.937-.011-3.285-.064-4.445c-.049-1.073-.228-1.655-.379-2.043c-.2-.513-.437-.88-.822-1.265a3.413 3.413 0 0 0-1.265-.822c-.388-.151-.97-.33-2.043-.379zm-5.85 12.345a3.669 3.669 0 0 0 4-5.986a3.67 3.67 0 1 0-4 5.986zM8.002 8.002a5.654 5.654 0 1 1 7.996 7.996a5.654 5.654 0 0 1-7.996-7.996zm10.906-.814a1.337 1.337 0 1 0-1.89-1.89a1.337 1.337 0 0 0 1.89 1.89z"
                                      fill="#626262"></path>
                            </g>
                        </svg>
                    </a>
                </div>
			<?php } ?>
        </div>
		<?php if ( $post->post_content ) { ?>
            <div class="about-team-item__text"><?php echo wpautop( $post->post_content ); ?></div>
		<?php } ?>
    </div>
</div>