<?php
$block_attributes = $args['block_attributes'] ?? [];

global $post;
if ( $post->post_excerpt ) {
	$text = $post->post_excerpt;
}
else {
	$text = Helper::short_string( wp_strip_all_tags( $post->post_content ), 50 );
}
$icon_id     = get_post_meta( $post->ID, 'service_icon', 1 );
$price       = get_post_meta( $post->ID, 'price', 1 );
$price_old   = get_post_meta( $post->ID, 'price_old', 1 );
$button_text = get_post_meta( $post->ID, 'button_text', 1 );
$button_link = get_post_meta( $post->ID, 'button_link', 1 );

$btn_flare = '';
if ( $block_attributes ) {
	if ( isset( $block_attributes['buttonsView'] ) && 'animate' == $block_attributes['buttonsView'] ) {
		$btn_flare = 'btn-flare ';
	}
}
else {
	if ( get_theme_mod( 'services_button_type' ) == 'animation' ) {
		$btn_flare = 'btn-flare ';
	}
}
?>
<div class="additional-services__slide">
    <div class="additional-services-item">
		<?php if ( $icon_id ) { ?>
            <div class="additional-services-item__img">
				<?php echo wp_get_attachment_image( $icon_id, 'medium' ); ?>
            </div>
		<?php } ?>
        <div class="additional-services-item__body">
            <div class="additional-services-item__title"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></div>
            <div class="additional-services-item__text"><?php echo $text; ?></div>
			<?php if ( $price ) { ?>
                <div class="additional-services-item__price">
                    <div class="additional-services-item__price-current"><?php echo $price; ?></div>
					<?php if ( $price_old ) { ?>
                        <div class="additional-services-item__price-old"><?php echo $price_old; ?></div>
					<?php } ?>
                </div>
			<?php } ?>
			<?php if ( $button_text && $button_link ) { ?>
				<?php
				$class_popup = '';
				if ( strpos( $button_link, '#wescle-modal' ) !== false || strpos( $button_link, '#modal' ) !== false ) {
					$class_popup = '_popup-link';
				}
				else {
					$class_popup = 'js-link';
				}
				?>
                <span class="btn btn-main <?php echo $btn_flare; ?><?php echo $class_popup; ?>" data-href="<?php echo $button_link; ?>" data-link="<?php echo $button_link; ?>"><?php echo $button_text; ?></span>
			<?php } ?>
        </div>
    </div>
</div>