<?php
global $post;

$args          = get_query_var( 'template_args' );
$services_data = isset( $args['services_data'] ) ? $args['services_data'] : '';

$thumbnail_size = 'medium_large';

$price = get_post_meta( $post->ID, 'price', 1 );
if ( isset( $services_data[ $post->ID ] ) && isset( $services_data[ $post->ID ]['price'] ) && $services_data[ $post->ID ]['price'] ) {
	$price = $services_data[ $post->ID ]['price'];
}

$price_old = get_post_meta( $post->ID, 'price_old', 1 );
if ( isset( $services_data[ $post->ID ] ) && isset( $services_data[ $post->ID ]['price_old'] ) && $services_data[ $post->ID ]['price_old'] ) {
	$price_old = $services_data[ $post->ID ]['price_old'];
}

$button_text  = get_post_meta( $post->ID, 'button_text', 1 );
$button_link  = get_post_meta( $post->ID, 'button_link', 1 );
$button_class = '';

$div_class = 'col services-items__col';
if ( isset( $services_data[ $post->ID ] ) && $services_data[ $post->ID ]['size'] == 'big' || is_archive() ) {
	$div_class .= ' services-items__col_big';
}

$img_class = 'services-item__image services-item__overlay_gradient';

$btn_flare = '';
if ( get_theme_mod( 'services_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}
?>
<div class="<?php echo $div_class; ?>">
    <a class="services-item" href="<?php the_permalink(); ?>">
        <div class="<?php echo $img_class; ?>">
			<?php the_post_thumbnail( $thumbnail_size ); ?>
        </div>
        <div class="services-item__body">
			<?php if ( $price ) { ?>
                <div class="services-item__price price">
                    <span><?php echo $price; ?></span>
					<?php if ( $price_old ) { ?>
                        <span class="price_old"><?php echo $price_old; ?></span>
					<?php } ?>
                </div>
			<?php } ?>
            <div class="services-item__title"><?php the_title(); ?></div>
            <div class="services-item__text">
				<?php
				if ( $post->post_excerpt ) {
					echo $post->post_excerpt;
				}
				else {
					echo Helper::short_string( wp_strip_all_tags( $post->post_content ), 50 );
				}
				?>
            </div>
			<?php if ( $button_text && $button_link ) { ?>
				<?php
				$class_popup = '';
				if ( strpos( $button_link, '#wescle-modal' ) !== false || strpos( $button_link, '#modal' ) !== false ) {
					$class_popup = '_popup-link';
				}
				else {
					$class_popup = 'js-link';
				}
				?>
                <span class="services__btn btn btn-main btn-main_blue <?php echo $btn_flare; ?><?php echo $class_popup; ?>" data-href="<?php echo $button_link; ?>" data-link="<?php echo $button_link; ?>"><?php echo $button_text; ?></span>
			<?php } ?>
        </div>
    </a>
</div>