<?php
$button_text   = $args['button_text'] ?? '';
$btn_flare     = $args['btn_flare'] ?? '';
$button_source = $args['button_source'] ?? __( 'Источник', 'wescle' );

$source = get_post_meta( $post->ID, 'source', 1 );

$youtube_link = get_post_meta( $post->ID, 'youtube_link', 1 );
$video_id     = Helper::get_youtube_video_id( $youtube_link );

$video_img_src = get_template_directory_uri() . '/assets/img/thumbnail-placeholder.jpg';
if ( $video_id ) {
	if ( $img_id = get_post_meta( $post->ID, 'thumbnail_video', 1 ) ) {
		$video_bg = wp_get_attachment_image_src( $img_id, 'medium_large' );
		if ( $video_bg ) {
			$video_img_src = $video_bg[0];
		}
	}
}

$review_class = 'reviews-slider-item__body';
if ( $video_id ) {
	$review_class = 'reviews-slider-item__body with_video';
}

$rating_html = '';
$rating      = floatval( get_post_meta( $post->ID, 'rating', 1 ) );
if ( $rating > 0 ) {
	if ( $rating > 5 ) {
		$rating = 5;
	}
	$rating      = round( $rating / 5 * 100, 0 );
	$rating_html = '<div class="_rating"><div class="star-rating" role="img"><span style="width:' . $rating . '%"></span></div></div>';
}
$rating_after_title = get_post_meta( $post->ID, 'rating_after_title', 1 );
?>
<div class="reviews-slider__item reviews-slider-item">
    <div class="reviews-slider-item__author author">
        <div class="author__photo image-bg">
			<?php the_post_thumbnail( 'thumbnail' ); ?>
        </div>
        <div class="author__info">
			<?php if ( $rating_html && ! $rating_after_title ) { ?>
				<?php echo $rating_html; ?>
			<?php } ?>
            <div class="author__name"><?php the_title(); ?></div>
			<?php if ( $sub_title = get_post_meta( $post->ID, 'sub_title', 1 ) ) { ?>
                <div class="author__position"><?php echo $sub_title; ?></div>
			<?php } ?>
			<?php if ( $date = get_post_meta( $post->ID, 'date_review', 1 ) ) { ?>
                <div class="reviews__time"><?php echo $date; ?></div>
			<?php } ?>
			<?php if ( $rating_html && $rating_after_title ) { ?>
				<?php echo $rating_html; ?>
			<?php } ?>
        </div>
    </div>
    <div class="<?php echo $review_class; ?>">
        <span class="icon-quote">
            <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" width="1em" height="1em" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveaspectratio="xMidYMid meet" viewbox="0 0 20 20">
              <path d="M8.54 12.74c0-.87-.24-1.61-.72-2.22c-.73-.92-2.14-1.03-2.96-.85c-.34-1.93 1.3-4.39 3.42-5.45L6.65 1.94C3.45 3.46.31 6.96.85 11.37C1.19 14.16 2.8 16 5.08 16c1 0 1.83-.29 2.48-.88c.66-.59.98-1.38.98-2.38zm9.43 0c0-.87-.24-1.61-.72-2.22c-.73-.92-2.14-1.03-2.96-.85c-.34-1.93 1.3-4.39 3.42-5.45l-1.63-2.28c-3.2 1.52-6.34 5.02-5.8 9.43c.34 2.79 1.95 4.63 4.23 4.63c1 0 1.83-.29 2.48-.88c.66-.59.98-1.38.98-2.38z" fill="#08c"></path>
            </svg>
        </span>
		<?php
		if ( $video_id ) {
			?>
            <div class="video-iframe lazy-background" data-background-image="<?php echo $video_img_src; ?>" data-src="https://www.youtube.com/embed/<?php echo $video_id; ?>?autoplay=1&rel=0&showinfo=0">
                <div class="btn-play">
                    <svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink" aria-hidden="true" focusable="false" style="-ms-transform: rotate(360deg); -webkit-transform: rotate(360deg); transform: rotate(360deg);" preserveAspectRatio="xMidYMid meet" viewBox="0 0 448 512">
                        <path d="M424.4 214.7L72.4 6.6C43.8-10.3 0 6.1 0 47.9V464c0 37.5 40.7 60.1 72.4 41.3l352-208c31.4-18.5 31.5-64.1 0-82.6z" fill="white"></path>
                    </svg>
                </div>
            </div>
			<?php
		}
		else {
			$is_limit    = false;
			$review_text = $post->post_content;
			echo str_replace( [ '<p', '</p>' ], [ '<div class="reviews-slider-item__text"', '</div>' ], wpautop( $review_text ) );
		}
		?>
    </div>
	<?php if ( ! $video_id ) { ?>
		<?php if ( $button_text || $source ) { ?>
            <div class="reviews-slider-item__buttons">
				<?php if ( $button_text || $is_limit ) { ?>
                    <button class="reviews-slider-item__button btn btn-main <?php echo $btn_flare; ?>" type="button"><?php echo esc_html( $button_text ); ?></button>
				<?php } ?>
				<?php if ( filter_var( $source, FILTER_VALIDATE_URL ) ) { ?>
                    <span class="btn btn-main js-link <?php echo $btn_flare; ?>" data-link="<?php echo $source; ?>"><?php echo $button_source; ?></span>
				<?php } ?>
            </div>
		<?php } ?>
	<?php } ?>
</div>