<?php
$price     = get_post_meta( $post->ID, 'price', 1 );
$price_old = get_post_meta( $post->ID, 'price_old', 1 );

$gradient_disable = get_post_meta( $post->ID, 'gradient_disable', 1 ) ? 'products-section-item__no_gradient' : '';

$button_text = get_post_meta( $post->ID, 'button_text', 1 );
$button_url  = get_post_meta( $post->ID, 'button_url', 1 );
$is_modal    = false;
if ( strpos( $button_url, '#' ) === 0 ) {
	$is_modal = true;
}

$btn_flare = '';
if ( Helper::is_frontpage_assets() && get_theme_mod( 'prodwescle_button_type' ) == 'animation' ) {
	$btn_flare = 'btn-flare ';
}
elseif ( isset( $args['btn_flare'] ) && $args['btn_flare'] ) {
	$btn_flare = 'btn-flare';
}
?>
<div class="products-section-item">
    <div class="products-section-item__img <?php echo $gradient_disable; ?>">
        <a href="<?php the_permalink(); ?>"><?php the_post_thumbnail( 'medium' ); ?></a>
    </div>
    <div class="products-section-item__body">
        <div class="products-section-item__title"><?php the_title(); ?></div>
        <div class="products-section-item__text">
			<?php
			if ( $post->post_excerpt ) {
				echo $post->post_excerpt;
			}
			else {
				echo Helper::short_string( wp_strip_all_tags( $post->post_content ), 150 );
			}
			?>
        </div>
		<?php if ( $price ) { ?>
            <div class="products-section-item__price">
                <div class="products-section-item__price-current"><?php echo $price; ?></div>
				<?php if ( $price_old ) { ?>
                    <div class="products-section-item__price-old"><?php echo $price_old; ?></div>
				<?php } ?>
            </div>
		<?php } ?>
		<?php if ( $button_text ) { ?>
			<?php
			if ( $is_modal ) {
				echo '<a class="btn btn-main btn-main_blue ' . $btn_flare . '" href="' . $button_url . '">' . $button_text . '</a>';
			}
			else {
				$link_data = '';
				if ( strpos( $button_url, home_url() ) === false ) {
					$link_data = 'target="_blank" rel="noopener noreferrer"';
					echo '<span class="btn btn-main btn-main_blue js-link ' . $btn_flare . '" data-link="' . $button_url . '">' . $button_text . '</span>';
				}
				else {
					echo '<a class="btn btn-main btn-main_blue ' . $btn_flare . '" href="' . $button_url . '" ' . $link_data . '>' . $button_text . '</a>';
				}
			}
			?>
		<?php } ?>
    </div>
</div>