<?php
global $post;

$args                = get_query_var( 'template_args' );
$home_portfolio_data = isset( $args['portfolio_data'] ) ? $args['portfolio_data'] : '';

$thumbnail_size = 'medium_large';

$div_class = 'col work-performed-items__col';
if ( isset( $home_portfolio_data[ $post->ID ] ) && $home_portfolio_data[ $post->ID ]['size'] == 'big' ) {
	$div_class .= ' work-performed-items__col_big';
}

$img_class = 'work-performed-item__image services-item__overlay_gradient';
?>
<div class="<?php echo $div_class; ?>">
    <a class="work-performed-item" href="<?php the_permalink(); ?>">
        <div class="<?php echo $img_class; ?>">
			<?php the_post_thumbnail( $thumbnail_size ); ?>
        </div>
        <div class="work-performed-item__body">
            <div class="work-performed-item__title"><?php the_title(); ?></div>
            <div class="work-performed-item__text">
				<?php
				if ( $post->post_excerpt ) {
					echo $post->post_excerpt;
				}
				else {
					echo Helper::short_string( wp_strip_all_tags( $post->post_content ), 50 );
				}
				?>
            </div>
        </div>
    </a>
</div>